#ifndef __ENCODE_H
#define __ENCODE_H

#include "tim.h"

// 定义电机数量
#define MOTOR_COUNT 4

// 编码器数据结构体
typedef struct {
    int32_t total_count;    // 累计脉冲总数（考虑溢出后的大数）
    uint16_t last_raw_cnt;  // 上次硬件寄存器的原始计数值
    int16_t speed;          // 最近一次采样周期的速度（脉冲增量）
} Encoder_T;

// 外部声明，方便 main.c 或 freertos.c 使用
extern Encoder_T g_encoder[MOTOR_COUNT];

/* 函数声明 */
void Encoder_Init_All(void);
void Encoder_Update_All(void);
void Encoder_Reset(uint8_t id);

#endif
