#ifndef __RGB_H
#define __RGB_H

#include "main.h"

#define PIXEL_NUM  8  // 灯珠数量

// 定义颜色结构体
typedef struct {
    uint8_t R;
    uint8_t G;
    uint8_t B;
} RGB_Color_t;

// 定义灯带结构体（可选，方便管理整串灯）
typedef struct {
    RGB_Color_t Pixel[PIXEL_NUM];
} RGB_Strip_t;

// 接口函数
void RGB_Init(void);
void RGB_SetFullColor(uint8_t r, uint8_t g, uint8_t b);
void RGB_SetPixelColor(uint8_t pixel[PIXEL_NUM][3]);

#endif
