#ifndef __AX_MPU6050_H
#define __AX_MPU6050_H

#include "main.h" // 包含HAL库相关定义

#define MPU6050_ADDR    0x68    // MPU6050器件地址

// MPU6050寄存器地址定义
#define MPU6050_SMPLRT_DIV      0x19
#define MPU6050_CONFIG          0x1A
#define MPU6050_GYRO_CONFIG     0x1B
#define MPU6050_ACCEL_CONFIG    0x1C
#define MPU6050_INT_ENABLE      0x38
#define MPU6050_ACCEL_XOUT_H    0x3B
#define MPU6050_TEMP_OUT_H      0x41
#define MPU6050_GYRO_XOUT_H     0x43
#define MPU6050_PWR_MGMT_1      0x6B
#define MPU6050_PWR_MGMT_2      0x6C
#define MPU6050_WHO_AM_I        0x75

// 范围定义
#define ACC_RANGE_2G   0
#define GYRO_RANGE_2000 3

// 函数声明 (保持原有命名)
void    MPU6050_Init(void);
void    MPU6050_GetAccData(int16_t *pbuf);
void    MPU6050_GetGyroData(int16_t *pbuf);
float   MPU6050_GetTempValue(void);

void    MPU6050_SetAccRange(uint8_t range);
void    MPU6050_SetGyroRange(uint8_t range);

#endif
