#include "usart1.h"
#include "buzz.h"
#include "pwm.h"

/**
  * @brief  启动串口接收
  */
void USART1_Config_Init(void)
{
    /* 使用扩展接收函数：接收到 RX_BUF_SIZE 个字节，或者遇到空闲中断时停止并回调 */
    HAL_UARTEx_ReceiveToIdle_IT(&huart1, RxBuffer1, RX_BUF_SIZE);
    printf("USART1 Multi-Byte Mode Ready.\r\n");
}

/**
  * @brief  printf 重定向 (保持不变)
  */
#ifdef __GNUC__
int __io_putchar(int ch) {
    HAL_UART_Transmit(&huart1, (uint8_t *)&ch, 1, HAL_MAX_DELAY);
    return ch;
}
#else
int fputc(int ch, FILE *f) {
    HAL_UART_Transmit(&huart1, (uint8_t *)&ch, 1, HAL_MAX_DELAY);
    return ch;
}
#endif

/**
  * @brief  业务逻辑：解析数据包
  * @param  pData: 指向接收缓冲区的指针
  * @param  Size: 接收到的有效数据长度
  */
void USART1_Process_Packet(uint8_t *pData, uint16_t Size)
{
    // 基础长度检查
    if (Size < 8) return; 

    for (int i = 0; i <= Size - 8; i++) {
        // 1. 检查帧头和帧尾
        if (pData[i] == 0x01 && pData[i+7] == 0xFF) {
            
            uint8_t r_mode  = pData[i+1];
            uint8_t r_value = pData[i+2];
            pwm_control_territory(r_mode, r_value);
            
          
 
        }
    }
}


