#include "usart_config.h"

uint8_t RxBuffer1[RX_BUF_SIZE]; // 接收缓冲区

// 接收缓冲区
uint8_t RxBuffer2[RX_BUF_SIZE]; 

/**
  * @brief  这是处理变长数据的关键回调函数
  * @param  huart: 串口句柄
  * @param  Size: 实际接收到的字节数
  */
void HAL_UARTEx_RxEventCallback(UART_HandleTypeDef *huart, uint16_t Size)
{
    if (huart->Instance == USART1)
    {
        // 1. 处理接收到的一包数据
        USART1_Process_Packet(RxBuffer1, Size);

        // 2. 接收完成后，必须再次开启监听
        HAL_UARTEx_ReceiveToIdle_IT(&huart1, RxBuffer1, RX_BUF_SIZE);
    }
    if (huart->Instance == USART2)
    {
        // 1. 处理接收到的二进制数据包
        USART2_Process_Packet(RxBuffer2, Size);

        // 2. 必须再次开启监听，以便下一次接收
        HAL_UARTEx_ReceiveToIdle_IT(&huart2, RxBuffer2, RX_BUF_SIZE);
    }
}

/**
  * @brief  如果发生错误（如溢出），在此重启接收
  */
void HAL_UART_ErrorCallback(UART_HandleTypeDef *huart)
{
    if (huart->Instance == USART1)
    {
        HAL_UARTEx_ReceiveToIdle_IT(&huart1, RxBuffer1, RX_BUF_SIZE);
    }
    if (huart->Instance == USART2)
    {
        HAL_UARTEx_ReceiveToIdle_IT(&huart2, RxBuffer2, RX_BUF_SIZE);
    }
}
