#ifndef AUDIO_MANAGER_H
#define AUDIO_MANAGER_H

#include <Arduino.h>
#include "pcm.h"         // 包含你的PCM音频数据头文件
#include "driver/i2s.h"  // 包含ESP32 I2S驱动头文件

class AudioManager {
private:
    // I2S 配置参数
    i2s_port_t _i2sPort = I2S_NUM_0; // 使用I2S端口0 (可配置)
    int _sampleRate = 8000;         // 音频采样率 (Hz) (可配置)
    int _bitsPerSample = I2S_BITS_PER_SAMPLE_16BIT; // 每个采样点的位数
    i2s_channel_fmt_t _channelFormat = I2S_CHANNEL_FMT_ONLY_LEFT;//I2S_CHANNEL_FMT_RIGHT_LEFT; // 通道格式
    i2s_comm_format_t _commFormat = I2S_COMM_FORMAT_STAND_I2S; // 通信格式
    int _dmaBufCount = 8;           // DMA缓冲区数量 (可配置)
    int _dmaBufLen   = 2048;        // 每个DMA缓冲区的长度 (字节) (可配置)

    // I2S 引脚
    int _bckPin;
    int _lrcPin;
    int _dinPin; // MAX98357A 不需要 DIN

    bool _audioplay_index = false;

    bool _playRequested = false; // 播放请求标志

    // 内部播放爆炸函数（在任务中调用）
    void play();

    // 内部播放滴滴函数（在任务中调用）
    void play_Drip_sound();

public:
    // 构造函数
    AudioManager(int bckPin, int lrcPin, int dinPin, int sampleRate = 16000, int dmaBufCount = 8, int dmaBufLen = 1024);

    // 初始化 I2S
    bool begin();

    // 请求播放爆炸音频（任务会检查此标志）
    void requestPlay();

     // 请求播放滴滴音频（任务会检查此标志）
    void requestPlay_Drip();

    // 检查当前是否正在播放（如果play()是阻塞的，这个可能没意义，除非在play()内部设置标志）
    bool isPlaying() const;


    // FreeRTOS 任务函数（需要在主文件或单独的.cpp中实现，并友元声明）
    // Friend declaration to allow the task function to access private members if needed
    friend void audioPlayTask(void* pvParameters);
};

// FreeRTOS 任务函数声明
void audioPlayTask(void* pvParameters);

#endif // AUDIO_MANAGER_H