#ifndef DEVICE_CONTROL_H
#define DEVICE_CONTROL_H

#include <Arduino.h>
#include "AudioManager.h"
// #include "MQTTManager.h" // 需要与 MQTTManager 交互以发布传感器数据
 
class AudioManager;

// class MQTTManager; // 前向声明

class DeviceControl {
private:
    int _outputPins[8]; // 存储输出引脚的 GPIO 编号
    int _sensorPin;     // 存储传感器输入引脚的 GPIO 编号

    int _ledblood = 6;    // 用于控制 LED "血量" 效果的状态变量
    int _led_count = 0;     // LED 闪烁效果的计数器 (用于 updateLedBlood)
    int _smoke_count = 0;
    int _smoke_ms = 0;
    bool _smoke_index =false;

    int _led_index=0;
    // int _beat_count=0;

    int _shot_count=0;

    int _smoke_time=0;

    int _sleep_ms=25;

    AudioManager *_audiomanager=nullptr;
    

    //MQTTManager* _mqttManager = nullptr; // MQTT 管理器指针，用于发布传感器数据

    // 内部函数
    void setPinValue(int pinIndex, int val); // 控制数字输出
    void setPWMValue(int pinIndex, int val); // 控制 PWM 输出

    // 更新 LED 血量效果
    void updateLedBlood();

    // 读取传感器值
    int readSensor();

public:
    
    // 构造函数
    // 传入输出引脚和传感器引脚的 GPIO 编号
    DeviceControl(int K1, int K2, int K3, int K4, int pin1,int pin2,int pin3,int pin4, int sensorPin);

    void devicecontrolaudio(AudioManager *audio_device){_audiomanager=audio_device;}
    // 初始化引脚模式等
    void begin();

    void set_smoke_index(bool index){_smoke_index = index;}

    void set_smoke_time(int time){_smoke_time=time;}

    int getLedBlood() const {
        return _ledblood;
    }

    void setledblood(int led){
        _ledblood=led;
    }

    bool getsmoke() const {
        return _smoke_index;
    }

    int read_gpio();

    //心跳函数
    //void updatebeartheat();

    // 设置 MQTTManager 指针
    // void setMQTTManager(MQTTManager* mqttManager) { _mqttManager = mqttManager; }

    // 从外部设置 LED 血量值 (例如来自 MQTT)
    void setLedBlood(int blood) { _ledblood = constrain(blood, 0, 6); _led_count = 0; } // 限制范围，重置计数器

    // 处理来自 MQTT 的控制指令（例如设置引脚或 PWM）
    //void handleMQTTCommand(int message_type, JsonObject body);

    // 在周期性任务中调用，更新LED状态并读取/发布传感器数据
    void update();

    // FreeRTOS 任务函数（需要  在主文件或单独的.cpp中实现，并友元声明）
    friend void devicePeriodicTask(void* pvParameters);

    //烟雾传感器
    void updatecontrol_smoke();


};

// FreeRTOS 任务函数声明
void devicePeriodicTask(void* pvParameters);


#endif // DEVICE_CONTROL_H