#include "DeviceControl.h"
#include "oled1306.h"

oledcontrol::oledcontrol(int scl, int sda) 
    : display(128, 64, &Wire, -1),  // 必须在这里初始化
      _device_control(nullptr) {
    _iic_pin[0] = sda;
    _iic_pin[1] = scl;
}

int oledcontrol::begin() {
    Wire.begin(_iic_pin[0], _iic_pin[1]);
    Serial.println("SSD1306 init attempt");
    
    if(!display.begin(SSD1306_SWITCHCAPVCC, 0x3C)) {
        Serial.println("SSD1306 init failed");
        return -1;
    }
    
    display.clearDisplay();
    display.display();
    return 0;  // 必须明确返回值
}

void oledcontrol::update(){
  if(_device_control->read_gpio()==0){
    if(key_j==0){
      key_i = (key_i > 0) ? key_i - 1 : 0;
      _oled_index=0;
    }
    else if(key_j==1)key_i = (key_i > 0) ? key_i - 1 : 0;
    
  }else  if(_device_control->read_gpio()==1){
    if(key_j==0) {
      key_i = (key_i < 5) ? key_i + 1 : 4;
      _oled_index=0;
    }
    else if(key_j==1) {
      key_i = (key_i < 100) ? key_i + 1 : 99;
    }
  }else   if(_device_control->read_gpio()==2){
     key_j = (key_j > 0) ? key_j - 1 : 0;
     if(key_j==0) key_i=0;
     _oled_index=0;
  }else   if(_device_control->read_gpio()==3){
      key_j = (key_j < 3) ? key_j + 1 : 2;
     if(key_j<2)  _oled_index=0;
  }
}

void oledcontrol::oledinit() {
    display.clearDisplay();
    display.setTextSize(1);              //设置字体大小为1:3
    display.setTextColor(SSD1306_WHITE); //设置字体颜色为白色
    display.setCursor(22, 0);
    display.print("-----menu-----");             //打印输入的字符
    display.setCursor(10, 12);
    display.print("1- blood set");             //打印输入的字符
    display.setCursor(90, _oled_count);
    display.print("*");             //打印输入的字符
    display.setCursor(10, 24);
    display.print("2- smoke set");
    display.setCursor(10, 36);
    display.print("3- restart");
    display.setCursor(10, 48);
    display.print("4- reboot");
    display.display();       
}

void oledcontrol::oled_booldset(int blood) {
    display.clearDisplay();
    display.setTextSize(1);              //设置字体大小为1:3
    display.setTextColor(SSD1306_WHITE); //设置字体颜色为白色
    display.setCursor(22, 0);
    display.print("--blood set--");
    display.setCursor(10, 12);
    display.fillRect(10, 12,20, 12, SSD1306_BLACK);
    if(blood>6)blood=6;
    display.print("blood:");
    display.setCursor(90, 12);
    display.print(blood);
    display.setCursor(10, 50);
    display.print("#:return  *:save");
    display.display();  
}

void oledcontrol::oled_update(){

  if(key_j==0&&_oled_index==0){
    oledinit();
    display.fillRect(90, _oled_count,20, 12, SSD1306_BLACK);
    if(key_i == 0)_oled_count=12;
    else if(key_i == 1)_oled_count=24;
    else if(key_i == 2)_oled_count=36;
    else if(key_i == 3)_oled_count=48;
    // display.setTextSize(1);              //设置字体大小为1:3
    // display.setTextColor(SSD1306_WHITE); //设置字体颜色为白色
    display.setCursor(90, _oled_count);
    display.print("*");             //打印输入的字符 
    display.display(); // 刷新屏幕
    //Serial.println("down");
    _oled_index==1;
  } 
  if(key_i==0&&key_j>=1&&_oled_index==0){
     _oled_index=3;
  }else if(key_i==1&&key_j>=1&&_oled_index==0){
     _oled_index=4;
  } else if(key_i==2&&key_j>=1&&_oled_index==0){
      Serial.println("reset");
      _device_control->setLedBlood(6);
      key_j=0;
      _oled_index=1;
  } else if(key_i==3&&key_j>=1&&_oled_index==0){
     Serial.println("reboot");
      ESP.restart();
      key_j=0;
      _oled_index=1;
  }

  if(_oled_index==3){
    oled_booldset(key_i);
    if(key_j>=2) {
      Serial.println("save");
      _preferences.begin("led_save", false);
      _preferences.putInt("led_blood", key_i);
      _preferences.end(); 
      _device_control->setLedBlood(key_i);
      key_j=0;
      key_i=0;
      _oled_index=0;
    }
  }else if(_oled_index==4){

  }
}

void oledPeriodicTask(void* pvParameters){
  oledcontrol* OLEDcontrol = static_cast<oledcontrol*>(pvParameters);
       if (!OLEDcontrol) {
        Serial.println("OLED Periodic Task: Invalid parameter!");
        vTaskDelete(NULL);
        return;
    }
    while(1){
      OLEDcontrol->update();
      OLEDcontrol->oled_update();
      vTaskDelay(pdMS_TO_TICKS(50)); // 每 50 毫秒更新一次
    }

}
