#include "DeviceControl.h"
// #include "AudioManager.h"
// #include <ArduinoJson.h> // 需要用于 handleMQTTCommand


// 构造函数实现
DeviceControl::DeviceControl(int K1, int K2, int K3, int K4, int pin1, int pin2, int pin3, int pin4,int sensorPin)
: _sensorPin(sensorPin) {
    _outputPins[0] = K1;
    _outputPins[1] = K2;
    _outputPins[2] = K3;
    _outputPins[3] = K4;
    _outputPins[4] = pin1;
    _outputPins[5] = pin2;
    _outputPins[6] = pin3;
    _outputPins[7] = pin4;
}

// begin 方法实现
void DeviceControl::begin() {
    Serial.println("DeviceControl initializing...");
    // 配置引脚模式
    for (int i = 0; i < 4; ++i) {
        pinMode(_outputPins[i], INPUT_PULLUP);
    }
    for (int i=4 ;i<8;i++){
        pinMode(_outputPins[i], OUTPUT);
    }
    pinMode(_sensorPin, INPUT); // 传感器引脚设为输入
    Serial.println("DeviceControl initialized.");
}

// 设置数字输出实现 (1-4 对应 _outputPins 数组索引 0-3)
void DeviceControl::setPinValue(int pinIndex, int val) {
    if (pinIndex >= 1 && pinIndex <= 4) {
        //Serial.printf("Setting digital pin %d (%d) to %d\n", pinIndex, _outputPins[pinIndex - 1], val);
        digitalWrite(_outputPins[pinIndex + 4 - 1], val == 1 ? HIGH : LOW);
    } else {
        Serial.printf("Warning: Invalid pin index for digital write: %d\n", pinIndex);
    }
}

// 设置 PWM 输出实现 (1-4 对应 _outputPins 数组索引 0-3)
void DeviceControl::setPWMValue(int pinIndex, int val) {
     if (pinIndex >= 1 && pinIndex <= 4) {
        // analogWrite 在 ESP32 上是 8 位分辨率 (0-255)
        int analogVal = constrain(val * 255 / 100, 0, 255); // 将输入的 0-100 值映射到 0-255
        //Serial.printf("Setting PWM pin %d (%d) to %d (scaled to %d)\n", pinIndex, _outputPins[pinIndex - 1], val, analogVal);
        analogWrite(_outputPins[pinIndex - 1], analogVal);
    } else {
        Serial.printf("Warning: Invalid pin index for PWM write: %d\n", pinIndex);
    }
}

// 更新 LED 血量效果实现
void DeviceControl::updateLedBlood() {
  // 这个函数需要在周期性的任务中被调用，比如每几十毫秒一次
  _led_count++; // 每次调用都递增计数器
  if (_led_count > 20) _led_count = 0; // 闪烁周期计数器

  if (_ledblood >= 6) { // 满血或更高，3个灯全亮
    setPinValue(1,1);
    setPinValue(2,1);
    setPinValue(3,1);
  } else if (_ledblood == 5){ // 5格血，灯1闪烁，灯2、3常亮
    setPinValue(1, (_led_count < 10)); // 计数器 < 10 时为高电平
    setPinValue(2,1);
    setPinValue(3,1);
  } else if (_ledblood == 4){ // 4格血，灯1灭，灯2、3常亮
    setPinValue(1,0);
    setPinValue(2,1);
    setPinValue(3,1);
  } else if (_ledblood == 3){ // 3格血，灯2闪烁，灯3常亮，灯1灭
    setPinValue(2, (_led_count < 10));
    setPinValue(1,0);
    setPinValue(3,1);
  } else if (_ledblood == 2){ // 2格血，灯3常亮，灯1、2灭
    setPinValue(1,0);
    setPinValue(2,0);
    setPinValue(3,1);
  } else if (_ledblood == 1){ // 1格血，灯3闪烁，灯1、2灭
    setPinValue(3, (_led_count < 10));
    setPinValue(1,0);
    setPinValue(2,0);
  } else { // ledblood <= 0，所有灯灭
    setPinValue(1,0);
    setPinValue(2,0);
    setPinValue(3,0);
  }
}
 
int DeviceControl::read_gpio() {
if(digitalRead(_outputPins[0])==LOW) {
  vTaskDelay(pdMS_TO_TICKS(40));
  if(digitalRead(_outputPins[0])==LOW) return 0;
}
if(digitalRead(_outputPins[1])==LOW) {
  vTaskDelay(pdMS_TO_TICKS(40));
  if(digitalRead(_outputPins[1])==LOW) return 1;
}
if(digitalRead(_outputPins[2])==LOW) {
  vTaskDelay(pdMS_TO_TICKS(40));
  if(digitalRead(_outputPins[2])==LOW) return 2;
}
if(digitalRead(_outputPins[3])==LOW) {
  vTaskDelay(pdMS_TO_TICKS(40));
 if(digitalRead(_outputPins[3])==LOW) return 3;  
}
  return -1;
  // put your main code here, to run repeatedly:
}

// 读取传感器值实现
int DeviceControl::readSensor() {
    // int rawValue = analogRead(_sensorPin);
    // // 将读数转换为电压（假设 ADC 12位，参考电压 3.3V 或 2.5V）
    // // ESP32C3 ADC 可以是 12位 (0-4095)，参考电压通常是 3.3V 内部或外部。
    // // 原始代码使用了 2.5，我们假设是 2.5V 参考电压，或者原始代码有误。
    // // 使用 3.3V 参考电压是更常见的做法: rawValue * 3.3 / 4095.0
    // // 如果你的电路使用了外部 2.5V 参考或其他方式，请调整下面的乘数
    // const double referenceVoltage = 3.3; // 假设使用 3.3V 参考电压
    // double voltage = (double)rawValue * referenceVoltage / 4095.0;
    // Serial.printf("Sensor raw: %d, Voltage: %.2fV\n", rawValue, voltage); // 调试信息
    int digitalValue = digitalRead(_sensorPin);
    return (digitalValue == HIGH) ? 1 : 0;
    // return voltage;
}



void DeviceControl::updatecontrol_smoke() {
    int _smoke_ms=_smoke_time*(1000/_sleep_ms);
    if(_smoke_index = true){
        if(_smoke_ms != 0){
            setPinValue(4,1); 
        }else setPinValue(4,0); 
        _smoke_ms--;
        if(_smoke_ms = 0) {
          _smoke_ms =0;
        }
    }

}

// 更新方法，在周期性任务中调用
void DeviceControl::update() {

    // 更新 LED 状态
    updateLedBlood();
    // 更新 烟雾 状态
    updatecontrol_smoke(); 

    _led_index ++;
    if (_ledblood > 0 &&readSensor() == 1&&_led_index>40){
      Serial.printf("shotend");
        _ledblood =_ledblood-1;
        _audiomanager->requestPlay();
        if(_ledblood<0) _ledblood =0;
        _led_index =0;
    }   
    if(_led_index>200)_led_index=201;
    
}


// FreeRTOS 任务函数实现
void devicePeriodicTask(void* pvParameters) {
    DeviceControl* deviceControl = static_cast<DeviceControl*>(pvParameters);
     if (!deviceControl) {
        Serial.println("Device Periodic Task: Invalid parameter!");
        vTaskDelete(NULL);
        return;
    }

    for (;;) {
        deviceControl->update(); // 调用 DeviceControl 的 update 方法
        vTaskDelay(pdMS_TO_TICKS(deviceControl->_sleep_ms)); // 每 50 毫秒更新一次
    }
}