// #include "AudioManager.h"
#include <Arduino.h>
#include <freertos/FreeRTOS.h> // FreeRTOS 实时操作系统核心库
#include <freertos/task.h>     // FreeRTOS 任务管理库

#include "DeviceControl.h"
#include "AudioManager.h"
#include "oled1306.h"

#define I2C_SDA 4
#define I2C_SCL 5
#define K4_PUSH 3
#define K3_PUSH 7
#define K2_PUSH 6
#define K1_PUSH 10
#define PIN_1 12
#define PIN_2 18
#define PIN_3 19
#define PIN_4 8
#define SERIOR 2

// -- I2S 引脚 --
#define I2S_BCLK  13// I2S 位时钟引脚
#define I2S_LRC   1// I2S 左右时钟引脚
#define I2S_DIN   0// I2S 数据输入引脚 (MAX98357A 不使用)


DeviceControl deviceControl(K1_PUSH,K2_PUSH,K3_PUSH,K4_PUSH,PIN_1,PIN_2,PIN_3,PIN_4,SERIOR);

oledcontrol oledcontrol(I2C_SCL,I2C_SDA);

AudioManager audioManager(I2S_BCLK,I2S_LRC,I2S_DIN);

void setup() {
  Serial.begin(115200);

  delay(1000); 

  deviceControl.begin(); 
  oledcontrol.begin();
  audioManager.begin();

  oledcontrol.setdevicecontrol(&deviceControl);

  deviceControl.devicecontrolaudio(&audioManager);
  // initialize the pushbutton pin as an input:

  xTaskCreate(audioPlayTask, "AudioPlay", 4096, (void*)&audioManager, 1, NULL);

  xTaskCreate(oledPeriodicTask, "oledcontrol", 2048, (void*)&oledcontrol, 1, NULL); // 将 实例地址传递给按键任务

  xTaskCreate(devicePeriodicTask, "DevicePeriodic", 2048, (void*)&deviceControl, 1, NULL); // 将 deviceControl 实例地址传递给设备任务

  // put your setup code here, to run once:
  audioManager.requestPlay_Drip(); // 请求播放启动音

  oledcontrol.oledinit();
}

void loop() {
 
  
  delay(1000);
}
