#ifndef OLED1306_H
#define OLED1306_H

#include <Arduino.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>
#include <Preferences.h>  // Flash 非易失性存储库，用于保存WiFi配置

#include <Wire.h>

// 前向声明代替包含头文件
class DeviceControl; 

class oledcontrol {
private:
    int _iic_pin[2];
    Adafruit_SSD1306 display;
    DeviceControl* _device_control = nullptr;
    int _oled_count=12;
    int _oled_index=0;
    int key_i=0;
    int key_j=0;

    Preferences _preferences;

    void oled_booldset(int boold);
    
public:
    oledcontrol(int scl, int sda);
    int begin();
    void setdevicecontrol(DeviceControl* device_control){_device_control=device_control;}
    void update();

    void oledinit();

    void oled_update();

    friend void oledPeriodicTask(void* pvParameters);
};

void oledPeriodicTask(void* pvParameters);
#endif