#ifndef BETTERYREAD_H
#define BETTERYREAD_H 

#include "esp_err.h"
#include "serial.h"

#define ADC_GET_VOLTAGE_GPIO  5
float board_get_voltage_v(void);
/**
 * @brief 初始化 ADC1 通道 4 (GPIO 5)
 */
esp_err_t board_adc_init(void);

#if defined(CONFIG_TYPE_CAR_0102)
    #define get_voltage_v() board_get_voltage_v()
    #define get_temperature() (0.0f) 

#elif defined(CONFIG_TYPE_ROBOT_0502)
    #define get_voltage_v()  get_stm32_battery_voltage()
    #define get_temperature() get_stm32_battery_tempvalue()
    
#elif defined(CONFIG_TYPE_CAR_0101)
    #define get_voltage_v() 
    
#else
    #error "请选择正确的设备型号"
#endif

#endif