#ifndef GPIOCONTROL_H
#define GPIOCONTROL_H

#include "driver/ledc.h"
#include "esp_err.h"

// 引脚定义
#define GPIO_PWM_MOTOR_6    6
#define GPIO_PWM_MOTOR_7    7
#define GPIO_PWM_SERVO_10   10
#define GPIO_PWM_ESC_15     15   // C615电调控制引脚
#define GPIO_PWM_ESC_16     16   // C615电调控制引脚

// LEDC 配置定义
#define LEDC_TIMER          LEDC_TIMER_0
#define LEDC_MODE           LEDC_LOW_SPEED_MODE
#define LEDC_DUTY_RES       LEDC_TIMER_13_BIT  // 13位分辨率 (0-8191)
#define FREQUENCY      50                 // 频率 50Hz

// 舵机角度换算 (基于 50Hz, 13-bit 分辨率)
// 0.5ms (0度) -> 约 205
// 1.5ms (90度) -> 约 614
// 2.5ms (180度) -> 约 1024
#define SERVO_MIN_DUTY      205   // 0.5ms
#define SERVO_MAX_DUTY      1024  // 2.5ms
#define SERVO_INIT_90_DEG   614   // 1.5ms (90度)


// ===== ESC PWM (50Hz, 13bit) =====
#define ESC_MIN_DUTY     410   // 1.0ms
#define ESC_MID_DUTY     614   // 1.5ms
#define ESC_MAX_DUTY     819   // 2.0ms

/**
 * @brief 初始化所有 PWM 引脚 (6, 7, 10)
 */
esp_err_t gpiocontrol_init(void);

void car0102_speed_stop(void);

void car0102_control_motor(int mode ,int val);

void esc_set_throttle(uint8_t percent);

#endif