#ifndef __WIFI_DEV_NUM_CONFIG_H__
#define __WIFI_DEV_NUM_CONFIG_H__

#include "esp_err.h"

// 引脚定义 (ESP32-S3 默认 BOOT 键一般是 0)
#define BTN_WIFI_IO     0
#define BTN_DEVID_IO    4

// 函数声明
void save_to_nvs(const char* key, const char* value);
esp_err_t read_from_nvs(const char* key, char* buf, size_t len);
void button_monitor_task(void* arg);
void start_config_web(void);
esp_err_t init_spiffs(void);

void nowifidata_start_config_web(void);

#endif