#ifndef GPIOCONTROL_H
#define GPIOCONTROL_H

#include "driver/ledc.h"
#include "esp_err.h"

// 引脚定义
#define GPIO_PWM_MOTOR_6    6
#define GPIO_PWM_MOTOR_7    7

#define GPIO_PWM_ESC_15     15   // C615电调控制引脚
#define GPIO_PWM_ESC_16     16   // C615电调控制引脚

// LEDC 配置定义
#define LEDC_TIMER          LEDC_TIMER_0
#define LEDC_MODE           LEDC_LOW_SPEED_MODE
#define LEDC_DUTY_RES       LEDC_TIMER_13_BIT  // 13位分辨率 (0-8191)
#define FREQUENCY      50                 // 频率 50Hz

// 舵机角度换算 (基于 50Hz, 13-bit 分辨率)
// 0.5ms (0度) -> 约 205
// 1.5ms (90度) -> 约 614
// 2.5ms (180度) -> 约 1024
#define SERVO_MIN_DUTY      205   // 0.5ms
#define SERVO_MAX_DUTY      1024  // 2.5ms
#define SERVO_INIT_90_DEG   614   // 1.5ms (90度)


// ===== ESC PWM (50Hz, 13bit) =====
#define ESC_MIN_DUTY     410   // 1.0ms
#define ESC_MID_DUTY     614   // 1.5ms
#define ESC_MAX_DUTY     819   // 2.0ms

/**
 * @brief 初始化所有 PWM 引脚 (6, 7, 10)
 */
esp_err_t gpiocontrol_init(void);
void car0102_speed_stop(void);
void car0102_control_motor(int mode ,int val);
void esc_set_throttle(int pin,int val);
void robot0502_stop(void);
void robot0502_control_motor(int mode ,int val);


#if defined(CONFIG_TYPE_CAR_0102)
    // 如果是 0102 型号，重定向到它的特定函数
    #define device_hardware_stop()  car0102_speed_stop()
    #define device_hardware_shot(pin,val)  do { } while(0)
    #define device_hardware_pintrol()  do { } while(0)
    #define device_hardware_control(mode, val) car0102_control_motor(mode, val)
    #define GPIO_PWM_SERVO_10   10
#elif defined(CONFIG_TYPE_ROBOT_0502)
    // 如果是其他型号
    #define device_hardware_stop()  robot0502_stop()
    #define device_hardware_shot(pin,val)  esc_set_throttle(pin,val)
    #define device_hardware_pintrol()  do { } while(0)
    #define device_hardware_control(mode, val) robot0502_control_motor(mode ,val)
    #define GPIO_PWM_SERVO_10   -1
#elif defined(CONFIG_TYPE_CAR_0101)
    // 通用型号
    #define device_hardware_stop()  car0101_speed_stop()
#else
    // 默认空操作，防止报错
    #error "请选择正确的设备型号"
#endif

#endif