#ifndef __SERIALOTA_H__
#define __SERIALOTA_H__ 

#include "esp_err.h"

/**
 * @brief 从 URL 下载 HEX 文件并存入 stm32ota 分区
 * @param url HEX 文件的下载链接
 * @return esp_err_t ESP_OK 表示下载成功并存储
 */
esp_err_t stm32_ota_download_from_url(const char *url);

/**
 * @brief 读取 stm32ota 分区中的 HEX 并通过串口烧录到 STM32
 * @return esp_err_t ESP_OK 表示烧录成功
 */
esp_err_t stm32_ota_start_update(void);

#if defined(CONFIG_TYPE_ROBOT_0502)

#define stm32_ota_update() stm32_ota_start_update()
#define stm32_ota_download_url(url) stm32_ota_download_from_url(url)

#endif

#endif