#ifndef __RGB_LED_H__
#define __RGB_LED_H__ 

#include "esp_err.h"
#include <stdint.h>


#define RGB_PIN     48  // 连接到RGB灯带数据线
#define LED_COUNT   8   // 8个RGB灯珠
#define RMT_RESOLUTION_HZ 10000000      // RMT分辨率：10MHz (0.1us)
#define RMT_TICK_PER_US  10             // 每微秒的tick数

// RMT配置
#define T0H_NS  350     // 0码高电平时间
#define T0L_NS  800     // 0码低电平时间
#define T1H_NS  700     // 1码高电平时间
#define T1L_NS  600     // 1码低电平时间

/**
 * @brief 初始化WS2812 LED灯带
 * @param gpio_num 控制引脚（如GPIO_NUM_48）
 * @param led_num LED数量
 * @return esp_err_t ESP_OK表示成功
 */
esp_err_t ws2812_init(void);

/**
 * @brief 设置所有LED颜色
 * @param r 红色值 (0-255)
 * @param g 绿色值 (0-255)
 * @param b 蓝色值 (0-255)
 */
void ws2812_set_color(uint8_t r, uint8_t g, uint8_t b);

/**
 * @brief 清除所有LED（关闭）
 */
void ws2812_clear(void);

#endif