#ifndef __SERIAL_H__
#define __SERIAL_H__
#include <stdint.h>
#include "esp_err.h"
#include <stdbool.h>

// 定义串口参数 (根据实际引脚修改)
#define STM32_UART_PORT      UART_NUM_1
#define STM32_TXD_PIN        (17)
#define STM32_RXD_PIN        (18)
#define STM32_BAUD_RATE      (115200)

typedef enum {
    BEAT_STOP,
    BEAT_START,
    BEAT_UNKNOWN
}beatstatus_e;

extern beatstatus_e beat_status;

float get_stm32_battery_tempvalue();
float get_stm32_battery_voltage();
void set_serial_enabled(bool enabled);
bool get_serial_enabled();

// 初始化串口
esp_err_t serial_init(void);
// 发送指令 (对应 STM32 的 USART2_Send_Command)
void serial_send_command(uint8_t mode, uint8_t value,uint8_t data3,uint8_t data4,uint8_t data5);

// 接收处理任务入口 (在 app_main 中启动)
void serial_receive_task(void *pvParameters);


#endif