#pragma once 
// mylog.h
#pragma once
#include <memory>
#include <iostream>
#include <spdlog/spdlog.h>
#include <spdlog/sinks/stdout_color_sinks.h>
#include <spdlog/sinks/rotating_file_sink.h>
#include <spdlog/fmt/ostr.h>


const std::string self_device_mylog_path = "/home/orangepi/online_move/master/log/log.log";

class MyLog {
public:
    static void init(const std::string &log_file = self_device_mylog_path) {
        if (logger) return;

        try {
            // 彩色控制台输出
            auto console_sink = std::make_shared<spdlog::sinks::stdout_color_sink_mt>();
            console_sink->set_pattern("[%Y-%m-%d %H:%M:%S.%e] [%^%l%$] [thread %t] %v");

            // 文件输出（支持大小滚动）
            // 最大 100 MB，保留 3 个旧文件
            //这个 true 的含义是 truncate = true（启动时清空已有的 log_file，并触发一次轮转）。
            //所以你每次重启，spdlog 都会把旧的 log.log 挪到 log.1.log，新建一个空的 log.log。
            auto file_sink = std::make_shared<spdlog::sinks::rotating_file_sink_mt>(
                log_file, 100 * 1024 * 1024, 3, false
            );
            file_sink->set_pattern("[%Y-%m-%d %H:%M:%S.%e] [%l] [thread %t] %v");

            // 多sink组合
            std::vector<spdlog::sink_ptr> sinks{console_sink, file_sink};
            logger = std::make_shared<spdlog::logger>("my_logger", sinks.begin(), sinks.end());

            spdlog::register_logger(logger);
            logger->set_level(spdlog::level::debug); // 默认等级
            logger->flush_on(spdlog::level::info);

        } catch (const spdlog::spdlog_ex &ex) {
            std::cerr << "Log initialization failed: " << ex.what() << std::endl;
        }
    }

    static std::shared_ptr<spdlog::logger>& get() {
        return logger;
    }

private:
    static std::shared_ptr<spdlog::logger> logger;
};

// 声明静态成员
inline std::shared_ptr<spdlog::logger> MyLog::logger = nullptr;

// 宏封装，调用更方便
#define mylog_trace(...)    MyLog::get()->trace(__VA_ARGS__)
#define mylog_debug(...)    MyLog::get()->debug(__VA_ARGS__)
#define mylog_info(...)     MyLog::get()->info(__VA_ARGS__)
#define mylog_warn(...)     MyLog::get()->warn(__VA_ARGS__)
#define mylog_error(...)    MyLog::get()->error(__VA_ARGS__)
#define mylog_critical(...) MyLog::get()->critical(__VA_ARGS__)