#pragma once
#include <string> // 必须包含 <string> 头文件以使用 std::string
#include <iostream>     // 包含输入输出流库

// 设备节点结构体定义
struct DeviceNode {
    std::string deviceId; // 设备ID，类型为字符串
    int coolDownTime;     // 冷却时间（秒）
    int usageTime;        // 使用时间（秒）
    DeviceNode* next;     // 指向下一个节点的指针

    // 构造函数声明
    DeviceNode(const std::string& id, int cool, int usage);
};

// 设备链表类声明
class DeviceList {
private:
    DeviceNode* head; // 指向链表头节点的指针
    DeviceNode* tail; // 指向链表尾节点的指针，用于高效添加

public:
    // 构造函数
    DeviceList();
    // 析构函数
    ~DeviceList();

    // 添加设备节点到链表末尾
    void addDevice(const std::string& id, int coolDown, int usage);

    // 根据设备ID删除节点
    bool deleteDevice(const std::string& id);

    // 根据设备ID修改节点信息
    bool modifyDevice(const std::string& id, int newCoolDown, int newUsage);

    // 显示所有设备信息 (const 关键字表示该函数不会修改类成员变量)
    void displayAllDevices() const;


    const DeviceNode* getHead() const {
        return head;
    }


    // 根据设备ID查找并显示设备信息 (const)
    bool findDevice(const std::string& id) const;
};