#pragma once 

#include <string>
#include <nlohmann/json.hpp>

using json = nlohmann::json;

struct positioningMapData {
    int id;//std::string
    int resWidth;
    int resHeight;
    int resX;
    int resY;
    int resZ;
};

// 这个函数只负责 positioningMapData 的转换，不应包含任何其他内容
void to_json(json& j, const positioningMapData& data) {
    j = json{
        {"id", data.id},
        {"resWidth", data.resWidth},
        {"resHeight", data.resHeight},
        {"resX", data.resX},
        {"resY", data.resY},
        {"resZ", data.resZ}
    };
}


std::string transfor_json( positioningMapData &data) {
    json j;
    j["body"] = data;
    j["head"] = {{"message_type", 1}};

    std::string json_payload = j.dump();
    return json_payload;
}
