// tank_data.hpp (正确的版本)
#ifndef TANK_DATA_HPP
#define TANK_DATA_HPP

#include <string>
#include <nlohmann/json.hpp>

using json = nlohmann::json;

struct TankWarMapData {
    int id;
    std::string type;
    int resWidth;
    int resHeight;
    int resX;
    int resY;
    int resZ;
};

// 这个函数只负责 TankWarMapData 的转换，不应包含任何其他内容
void to_json(json& j, const TankWarMapData& data) {
    j = json{
        {"id", data.id},
        {"type", data.type},
        {"resWidth", data.resWidth},
        {"resHeight", data.resHeight},
        {"resX", data.resX},
        {"resY", data.resY},
        {"resZ", data.resZ}
    };
}

#endif // TANK_DATA_HPP