#pragma once 

#include <iostream>
#include <string>
#include <vector>

struct deviceTable {
    struct Entry {
        std::string tag_id;
        std::string device_id;
    };

    std::vector<Entry> table;

    // 插入或更新
    void set(const std::string& tag_id, const std::string& device_id) {
        // 先查找是否已存在相同的 tag_id
        for (auto& e : table) {
            if (e.tag_id == tag_id) {
                e.device_id = device_id; // 覆盖
                return;
            }
        }
        // 如果不存在并且没超 20 个，就插入
        if (table.size() < 20) {
            table.push_back({tag_id, device_id});
        } else {
            std::cerr << "设备表已满，无法插入更多数据！" << std::endl;
        }
    }

    // 打印全部
    void print() const {
        std::cout << "设备表:" << std::endl;
        for (const auto& e : table) {
            std::cout << "Tag ID: " << e.tag_id 
                      << " -> Device ID: " << e.device_id << std::endl;
        }
    }

    std::string find(std::string find_tag_id) const {
       
        for (const auto& e : table) {
            if(find_tag_id == e.device_id){
                return e.tag_id;
            }
        }
        return "empty";
    }
};