#pragma once

#include "mqtt_controller.hpp" // 假设之前的 MqttController 类代码可用
#include <unordered_map>
#include <functional>
#include <vector>
#include "nlohmann/json.hpp"

class MqttTopicsHandler : public MqttController {
public:
    using JsonCallback = std::function<void(const std::string& topic, const nlohmann::json& json_payload)>;
    using SimpleJsonCallback = std::function<void(const nlohmann::json& json_payload)>;

    // 构造函数：启动工作线程
    MqttTopicsHandler(const std::string& broker_address, const std::string& client_id);
    // 析构函数：停止工作线程
    ~MqttTopicsHandler();

    // ... 其他方法保持不变 ...
    void InitBaseSubscription();
    void AddSubscription(const std::string& topic, JsonCallback callback);
    void AddSubscription(const std::string& topic, SimpleJsonCallback callback);
    void AddSubscriptions(const std::vector<std::string>& topics, SimpleJsonCallback common_callback);
    void RemoveSubscription(const std::string& topic);
    void PublishJson(const std::string& topic, const nlohmann::json& json_payload, int qos = 1, bool retained = false);

private:
    // 将订阅请求封装成一个任务
    void post_task(std::function<void()> task);
    // 工作线程的执行函数
    void worker_thread_func();

    std::unordered_map<std::string, JsonCallback> active_subscriptions_;
    
    // --- 新增的成员变量 ---
    std::queue<std::function<void()>> task_queue_; // 任务队列
    std::mutex queue_mutex_;                       // 保护队列的互斥锁
    std::condition_variable condition_;            // 用于唤醒工作线程的条件变量
    std::thread worker_thread_;                    // 工作线程
    std::atomic<bool> stop_worker_{false};         // 控制线程停止的原子标志
};