#include "file_operations.hpp"

// 打开文件
bool FileReader::open() {
    _fileStream.open(_filePath, std::ios::in);
    if (!_fileStream.is_open()) {
        std::cerr << "Failed to open file: " << _filePath << std::endl;
        return false;
    }
    return true;
}

// 读取整个文件内容为字符串
std::string FileReader::readAll() {
    if (!_fileStream.is_open()) {
        throw std::runtime_error("File not opened");
    }
    std::ostringstream ss;
    ss << _fileStream.rdbuf();
    return ss.str();
}

// 关闭文件
void FileReader::close() {
    if (_fileStream.is_open()) {
        _fileStream.close();
    }
}




