#ifndef THREAD_POOL_H
#define THREAD_POOL_H

#include "common.h"

// 任务结构体
typedef struct Task {
    void (*function)(void *);
    void *argument;
    struct Task *next;
} Task;

// 任务队列结构体
typedef struct {
    Task *head;
    Task *tail;
    int size;
    pthread_mutex_t mutex;
    pthread_cond_t cond;
} TaskQueue;

// 线程池结构体
typedef struct {
    pthread_t *threads;
    pthread_t reaper_thread;  // 新增：回收线程
    int thread_count;
    int min_threads;         // 新增：最小线程数
    int max_threads;         // 新增：最大线程数
    int active_threads;      // 新增：活跃线程数
    TaskQueue task_queue;
    int shutdown;
    pthread_mutex_t mutex;
    pthread_cond_t reaper_cond;  // 新增：回收线程条件变量
} ThreadPool;

// 初始化线程池
ThreadPool *thread_pool_init(int min_threads, int max_threads);

// 向线程池添加任务
int thread_pool_add_task(ThreadPool *pool, void (*function)(void *), void *argument);

// 销毁线程池
void thread_pool_destroy(ThreadPool *pool);

#endif // THREAD_POOL_H