#include "common.h"
#include "gpio_pwm_carship.h"
#include "gpio_pwm_car0102.h"
#include "gpio_pwm_car0103.h"
#include "gpio_pwm_car0104.h"
#include "gpio_pwm_ptz.h"
#include "gpio_pwm_tank0202.h"
#include "ip.h"
#include "opensh.h"
#include "INA226.h"
#include "heat.h"
#include "mqtt.h"
#include "warm.h"
#include "fileopen.h"
#include "device_change.h"
#include "judg.h"
#include "ads1115.h"
#include "audioplay.h"
#include "wifichange.h"
#include "mqtt_verify.h"

struct mosquitto *mosq;

int heartbeat_count=0;

char*  TOPIC = NULL;
char*  TOPIC2 = NULL;
char*  TOPIC3 = NULL;
char*  TOPIC4 = NULL;

char*  TOPIC_BACK = NULL;
char*  TOPIC2_BACK = NULL;
char*  TOPIC3_BACK = NULL;

int gPwmCount = 0;  // 计数
int gmessage_type=10086;

int message;//存放gmessage_type的值发送心跳，2，3消息为1；

uint16_t AppExit_pin_pwm=0;//判断坦克或者车的退出

int rc=0;//判断mqtt是否成功创建
//ThreadPool *pool;//线程池线程函数

unsigned char modeTemp=0;
unsigned char typeTemp=0;
unsigned char pinTemp=0;
unsigned char valTemp=0;
unsigned char gvalt[4];//存放mqtt接收的tpye，mode等

char  *glat=NULL;//加入gps后删除，心跳预留，不更改
char  *glon=NULL;//加入gps后删除，心跳预留，不更改

time_t gStart;//时间戳


//mqtt设备行走驱动函数
void device_driver(){
    if(AppExit_pin_pwm == 101) speed_change(gvalt) ;
    if(AppExit_pin_pwm == 102) car0102_speed_change(gvalt) ;
    if(AppExit_pin_pwm == 103 ) car0103_change(gvalt) ;
    if(AppExit_pin_pwm == 104 ) car0104_change(gvalt) ;
    if(AppExit_pin_pwm == 202) tank0202_change(gvalt);
    if(AppExit_pin_pwm == 301) ship_speed_change(gvalt) ;
    if(AppExit_pin_pwm == 401) PTZ_pwm_change(gvalt);
}

//mqtt初始化
int mqtt_init() {
    mosquitto_lib_init();
    // 这里创建mosq可以保留，也可以删除这一行，让创建放到 Mqtt_onnect 里
    mosq = mosquitto_new(NULL, true, NULL);
    if (!mosq) {
        my_zlog_fatal("Failed to create Mosquitto client");
        return -1;
    }
    mosquitto_int_option(mosq, MOSQ_OPT_PROTOCOL_VERSION, MQTT_PROTOCOL_V5);
    return 0;
}

//回调函数
void on_connect(struct mosquitto *mosq, void *obj, int rc) {
    if (rc == 0) {
        my_zlog_debug("Connected to broker");
        topic_middle_value();
        mosquitto_subscribe(mosq, NULL, TOPIC, 0);
        mosquitto_subscribe(mosq, NULL, TOPIC4, 0);
    } else {
        fprintf(stderr, "Connection failed with code %d\n", rc);
        my_zlog_fatal("Connection failed");
    }
}

//心跳发送格式*5/2
void heartbeat_send() {
    float voltage = INA226_readBusVoltage();
    float current = INA226_readCurrent();
    //my_zlog_debug("%.2f\n", voltage);
    if(voltage<=0.5){
        voltage=ads1115_read_channel(0)*5/2;
        current=ads1115_read_channel(1)*5/2;
        //my_zlog_debug("%.2f\n", voltage);
        current=(current-voltage)*100;
    }
    char voltage_str[20];  // 足够存储转换后的字符串的缓冲区
    sprintf(voltage_str, "%.2f", voltage); 
    char current_str[20];  // 足够存储转换后的字符串的缓冲区
    sprintf(current_str, "%.2f", current); 
   
    alarm_control(voltage);//判断电压警报,在不动时候才判断
    
    /*读取程序版本号*/
    char *version_num = program_version();

    if(heat_tem() !=0 ) {//获取CPU温度
        my_zlog_debug("获取cpu温度失败");
    }
    message=1;

    topic_middle_value();//指针中间函数

    cJSON *root = cJSON_CreateObject();
    cJSON *body = cJSON_CreateObject();
    cJSON *head = cJSON_CreateObject();

    cJSON_AddStringToObject(body, "ip", ip_address);//发送设备id
    cJSON_AddStringToObject(body, "ID", TOPIC);//发送设备号
    cJSON_AddStringToObject(body, "V", voltage_str);//心跳发送电压
    cJSON_AddStringToObject(body, "I", current_str);//心跳发送电流
    cJSON_AddStringToObject(body,"Tem",temperature);//发送温度
    cJSON_AddStringToObject(body, "N", glat);//gps
    cJSON_AddStringToObject(body, "E", glon);//gps
    cJSON_AddStringToObject(body, "version", version_num);//gps

    cJSON_AddNumberToObject(head, "message_type",message);

    cJSON_AddItemToObject(root, "body", body);
    cJSON_AddItemToObject(root, "head",head);

    char *payload = cJSON_PrintUnformatted(root);
    //printf("%s\n",payload);
    my_zlog_debug("%s",payload);
    mosquitto_publish(mosq, NULL, TOPIC2, strlen(payload), payload, 0, false); 
    mosquitto_publish(mosq, NULL, TOPIC3, strlen(payload), payload, 0, false); 
    
    cJSON_Delete(root);  // 释放 cJSON 对象
}

//角度发送
void angle_mqtt_send() { 
    float angle_shot=ads1115_read_channel(2);
    if(angle_shot>0){  
     angle_shot=angle_shot*360/5;
     //my_zlog_debug("%.2f",angle_shot);
     topic_middle_value();
    cJSON *root = cJSON_CreateObject();
    char TOPIC_send_angle[26];
    double rounded_angle = round(angle_shot * 100) / 100;
    sprintf(TOPIC_send_angle,"dev_rtinfo/%s",TOPIC3);
    cJSON_AddStringToObject(root, "type","tank_angle");
    cJSON_AddNumberToObject(root, "angle",rounded_angle);
    char *payload = cJSON_PrintUnformatted(root);
    my_zlog_debug("%s",payload);
    mosquitto_publish(mosq, NULL, TOPIC_send_angle, strlen(payload), payload, 0, false); 
    cJSON_Delete(root);  // 释放 cJSON 对象
    }

   
}

//心跳格式，每5s一次心跳
void mqtt_wirte(){

    if( heartbeat_count >= 30) heartbeat_send();
    if( AppExit_pin_pwm == 202) angle_mqtt_send();  

}

//message_type为3，控制pwm  
void message_3(cJSON *body){
    cJSON *pwm_ctrl = cJSON_GetObjectItem(body, "pwm_ctrl");
    cJSON *pin_setctrl = cJSON_GetObjectItem(body, "pin_setctrl");
    if(pwm_ctrl==NULL||pin_setctrl==NULL){ 
        return ;
    }
    cJSON *mode = cJSON_GetObjectItem(pwm_ctrl, "mode");   //mode=1 速度，mode=2 转向(unsigned char)
    cJSON *type = cJSON_GetObjectItem(pwm_ctrl, "type");
    cJSON *val =   cJSON_GetObjectItem(pwm_ctrl, "val");  //val为pwm的值 0~100(unsigned char)(unsigned char)
    
    modeTemp= mode->valueint;
    typeTemp=type->valueint;
    valTemp= val->valueint;

    gvalt[0]=typeTemp;
    gvalt[1]=modeTemp;
    gvalt[2]=valTemp;
    gPwmCount = 0;

    my_zlog_debug("typeTemp:%d",gvalt[0]);
    my_zlog_debug("modeTemp:%d",gvalt[1]);
    my_zlog_debug("valTemp:%d",gvalt[2]);

    device_driver();
        
}

void message_4(cJSON *body){//message 为4时候

    cJSON *pwm_ctrl = cJSON_GetObjectItem(body, "pwm_ctrl");
    cJSON *pin_setctrl = cJSON_GetObjectItem(body, "pin_setctrl");
    if(pwm_ctrl==NULL||pin_setctrl==NULL){ 
        return ;
    }
    cJSON *pin = cJSON_GetObjectItem(pin_setctrl, "pin");
    cJSON *val = cJSON_GetObjectItem(pin_setctrl, "val");  //val为pwm的值 0~100(unsigned char)(unsigned char)
    
    pinTemp=pin->valueint;
    valTemp= val->valueint;

    if(valTemp>=1){
        valTemp=1;
    }

    gPwmCount=0;
    gvalt[0]=0;
    gvalt[1]=pinTemp;
    gvalt[2]=valTemp;

    my_zlog_debug("pinTemp:%d",gvalt[1]);
    my_zlog_debug("valTemp:%d",gvalt[2]);

    pin_value(gvalt[1],gvalt[2]);
    pwm_value(gvalt[1],gvalt[2]);
    if(AppExit_pin_pwm == 202 ) tank_shot_back_stop(gvalt[1],gvalt[2]);
}

//当接收到2时候验证
void message_2_judyverify(cJSON *body){
    receive_jwt(body);
   if(gverify_index == 0) {
    refresh_cam();   
   } else {
    my_zlog_warn("验证不通过");
   }
}

//当接收到3时候验证
void message_3_judyverify(cJSON *body){
    receive_jwt(body);
   if(gverify_index == 0) {
    message_3(body);
   } else {
    my_zlog_warn("验证不通过");
   }
}

//当接收到4时候验证
void message_4_judyverify(cJSON *body){
    receive_jwt(body);
   if(gverify_index == 0) {
    message_4(body);
   } else {
    my_zlog_warn("验证不通过");
   }
}


//接收的下载的mqtt消息
int download_message(cJSON *body){
    if (cJSON_IsObject(body)) {
        // 获取 doby 对象
            // 获取 site 中的 name 和 url
            cJSON *name = cJSON_GetObjectItem(body, "name");
            cJSON *url = cJSON_GetObjectItem(body, "url");
            if (cJSON_IsString(name) && cJSON_IsString(url)) {
                my_zlog_debug("Site Name: %s", name->valuestring);
                my_zlog_debug("Site URL: %s", url->valuestring);
            }
        
            // 获取 type 中的 suf、dir 和 sername
            cJSON *down_suf = cJSON_GetObjectItem(body, "suf");
            //cJSON *down_dir = cJSON_GetObjectItem(type, "dir");&& cJSON_IsString(down_dir)
            cJSON *down_sername = cJSON_GetObjectItem(body, "sername");
            if (cJSON_IsString(down_suf)  && cJSON_IsString(down_sername)) {
                my_zlog_debug("Type Suf: %s", down_suf->valuestring);
                //my_zlog_debug("Type Dir: %s", down_dir->valuestring);
                my_zlog_debug("Type Sername: %s", down_sername->valuestring);
            }
        
    }else  return -1;

    return 0;
}

//接收到设备改名函数
int device_mqttchange_name(cJSON *device_id){
    cJSON *id = cJSON_GetObjectItem(device_id, "id");// 提取ID   
    cJSON *date = cJSON_GetObjectItem(device_id, "date");// 提取日期
    char *device_change_id=id->valuestring;
    char *device_change_date=date->valuestring;
    device_changename_back(device_change_date,device_change_id);
    // 输出提取的数据
    my_zlog_debug("设备ID: %s", device_change_id);
    my_zlog_debug("日期: %s", device_change_date);

    return 0;
}

int device_message_receive(cJSON *json){//接收到的控制设备的mqtt消息
    
    cJSON *head = cJSON_GetObjectItem(json, "head");
    cJSON *message_type = cJSON_GetObjectItem(head, "message_type");

    if (cJSON_IsObject(head)&&cJSON_IsNumber(message_type)) {;
            
        cJSON *body = cJSON_GetObjectItem(json, "body");//提取 body数据段
        if (!cJSON_IsObject(body)) {
            return 1;
        }

        gmessage_type=message_type->valueint;
        my_zlog_debug("message_type: %d",message_type->valueint);
        switch(gmessage_type){
            case 2:
                message_2_judyverify(body); 
                my_zlog_debug("进入刷新");
                break;
            case 3:
                message_3_judyverify(body);
                my_zlog_debug("进入pwm控制");
                break;
            case 4:
                message_4_judyverify(body);
                my_zlog_debug("进入引脚控制");
                break;
            case 2001: 
                audioplay_mqtt_receive(body);
                my_zlog_debug("进入音频播放");
                break;
            case 2002:
                device_mqttchange_name(body);
                my_zlog_debug("进入修改设备号");
                break;
            case 2003:
                scan_wifi_json();
                my_zlog_debug("进入查询WiFi");
                break;
            case 2004:
                wifi_change_recmqtt(body);
                my_zlog_debug("进入修改WiFi");
                break;
            case 2005:
                download_message(body);
                my_zlog_debug("进入下载");
                break;
            case 2006:
                message2006_verify(body);
                my_zlog_debug("进入消息为2006验证");
                break;
            case 2011:
                system("sudo reboot");//重启香橙派
                my_zlog_debug("重启成功");
                break;
            case 2012:
                refresh_cam();    
                my_zlog_debug("刷新成功");
                break;
            default:
                break;
        }
    }else return 3;     
 
    return 0;
}

//消息回环函数  
void on_message(struct mosquitto *mosq, void *obj, const struct mosquitto_message *message) {
    time_t end = time(NULL);

    if(gStart+5>end){
        //printf("正在处理过期消息\n");
        my_zlog_warn("正在处理过期消息");
        return;     
    }

    // 确保消息有效
    if (message->payload && message->payloadlen) { // 将消息内容转换为字符串
        char *payload_str = (char *)malloc(message->payloadlen + 1);
        if (!payload_str) {
            return;
        } 

        memcpy(payload_str, message->payload, message->payloadlen);
        payload_str[message->payloadlen] = '\0';

        // 解析 JSON
        cJSON *json = cJSON_Parse(payload_str);
        if(json != NULL){
            if(device_message_receive(json)==0) my_zlog_debug("进入设备接收mqtt");
        }                     
        
        // 释放 payload 字符串
        free(payload_str); 
        cJSON_Delete(json); 
    }
}

// 返回连接结果，0成功，非0失败
int mqtt_create(struct mosquitto *mosq) { 
    mosquitto_reconnect_delay_set(mosq, 2, 10, true);
    mosquitto_connect_callback_set(mosq, on_connect);
    mosquitto_message_callback_set(mosq, on_message);
    mosquitto_username_pw_set(mosq, USERNAME, PASSWORD);

    int rc = mosquitto_connect(mosq, BROKER_ADDRESS, BROKER_PORT, 60);
    if (rc != MOSQ_ERR_SUCCESS) {
        my_zlog_warn("Failed to connect to broker: %s", mosquitto_strerror(rc));
        // 不销毁 mosq，等待调用者处理重连
        return rc;
    }
    return 0; // 成功
}   

//阻塞型
int mqtt_cycle(struct mosquitto *mosq) {
    // 这个函数会阻塞直到连接断开或错误返回
    int rc = mosquitto_loop_forever(mosq, -1, 1);
    if (rc != MOSQ_ERR_SUCCESS) {
        my_zlog_warn("mqtt loop error: %s", mosquitto_strerror(rc));
        return rc;
    }
}

// int mqtt_cycle(struct mosquitto *mosq) {//非阻塞型
//     int rc;
//     while (1) {
//         rc = mosquitto_loop(mosq, 100, 1);  // 每秒检查一次
//         if (rc != MOSQ_ERR_SUCCESS) {
//             my_zlog_warn("mosquitto loop error: %s,(code: %d)", mosquitto_strerror(rc),rc);
//             return -1;  // 跳出循环，重新连接
//         }
//         Delay_Ms(0, 3);  // 防止空转
//     }
// }

//mqtt清理
void mqtt_clean(struct mosquitto *mosq){
      // 清理
    mosquitto_destroy(mosq);
    mosquitto_lib_cleanup();
    my_zlog_notice("清理成功");
}