#include "gpio_pwm_carship.h"
#include "gpio_pwm_ptz.h"
#include "ip.h"
#include "mqtt.h"
#include "delay.h"
#include "opensh.h"
#include "INA226.h"
#include "pthrpoll.h"
#include "heat.h"
#include "common.h"
#include "device_exit.h"
#include "thread_main.h"
#include "wifichange.h"
#include "mqtt_verify.h"

pthread_t thread[6];  // 全局线程句柄数组（或传参）

int gwebrtc_index=0;

int grc=0;

void* args[6] = { NULL, NULL, NULL, NULL, NULL, NULL };

int thread_start(ThreadFunc AppExit, ThreadFunc Mqttbeat,
                 ThreadFunc opensh, ThreadFunc Mqtt_onnect,
                 ThreadFunc delay_count, ThreadFunc play_mp3_thread) {
    
    ThreadFunc thread_funcs[] = {
        AppExit,
        Mqttbeat,
        opensh,
        Mqtt_onnect,
        delay_count,
        play_mp3_thread
    };

    for (int i = 0; i < 6; i++) {
        if (pthread_create(&thread[i], NULL, thread_funcs[i], args[i]) != 0) {
            my_zlog_error("创建线程 %d 失败", i);
            return i + 1;
        }
    }
    return 0;
}

//出现意外自动停止
void *AppExit(void *arg) { 
    while(1){    
        Delay_Ms(0,100);
        gPwmCount++;
        if(gPwmCount>=5) {
        device_warn_exit();
        gPwmCount=6;
        } 
    }
    return NULL; 
}

void *Mqttbeat(void *arg) { 
    //printf("Mqttbeat start\n");
    my_zlog_info("Mqttbeat start");
    Delay_Ms(5,0);
    wifi_change_sendmqtt_init();
    gwebrtc_index=1;
    while(1) {
        if( AppExit_pin_pwm == 202) Delay_Ms(0,45);
        if( AppExit_pin_pwm != 202) Delay_Ms(0,100);
        heartbeat_count++;
        if(grc == 0){
            ipaddr();//获取ip
            mqtt_wirte();//心跳，3s一个   
        }
        if(heartbeat_count>=30) heartbeat_count=0;   
    }
    return NULL;
}

void *opensh(void *arg) { 
    Delay_Ms(5,0);
    //printf("open cam\n");
    while(1){
        if(gwebrtc_index==1) {
            my_zlog_info("open cam");
            opencamsh();//10s后打开游览器并且进入网址 
        }

    }
    
    return NULL; 
}

//mqtt异常处理，断开自动重连，简单粗暴
void *Mqtt_onnect(void *arg) {
    Delay_Ms(5,0);

    if (mqtt_init() != 0) {
        my_zlog_fatal("mqtt_init failed");
        return NULL;
    }

    while (1) {
        if (mosq == NULL) {
            mqtt_init();
            if (!mosq) {
                mqtt_clean(mosq);
                my_zlog_error("Failed to create mosquitto client");
                continue;
            }
        }

        grc = mqtt_create(mosq);
        if (grc != 0) {
            mqtt_clean(mosq);
            mosq = NULL;
            continue;
        }

        grc = mqtt_cycle(mosq);  // 阻塞直到断开
        if(grc !=0 ){
            mqtt_clean(mosq);
            mosq = NULL;
        }
        my_zlog_warn("mqtt disconnected ...");
    }
    mqtt_clean(mosq);
    return NULL;
}

//专门用于计时的线程
void *delay_count(void *arg) {
    while (1) {
        Delay_Ms(0,5);
       device_delay_count++;//设备计时，坦克打击倒退逻辑
       gverify_count++;//验证计时,每15s一次
       if(gverify_count >= 20000) gverify_count = 20000;
       if(device_delay_count >= 5000) device_delay_count = 5000;
    }
    return NULL;
}

//专门处理MP3播放
void *play_mp3_thread(void* arg) {
    audioplay_cycle();
    return NULL;
}

// 等待线程结束
void thread_end() {
    pthread_join(thread[0], NULL);
    pthread_join(thread[1], NULL);
    pthread_join(thread[2], NULL);
    pthread_join(thread[3], NULL);
    pthread_join(thread[4], NULL);
    pthread_join(thread[5], NULL);
}

