#include "common.h"
#include "gpio_common.h"
#include "mqtt.h"
#include "request.h"
#include "gpio_pwm_tank0202.h"


#define MIN_DUTY 0  // 最小占空比
#define MAX_DUTY 100 // 最大占空比

int device_delay_count =0;//设备计算函数

int gpioPwm[30];//软件控制
int gpioWPi[40]; //能使用高低引脚和其他引脚

int gpioCount=0;
int gpio_softpwmCount=0;

void init_gpioWPi(int *values_pin) {
    while (values_pin[gpioCount] != -1) {
        gpioCount++;
    }
    for (int i = 0; i < gpioCount; i++) {
        gpioWPi[i] = values_pin[i];
    }     
    // 设置所有GPIO为输出模式
    for(int i = 0; i < gpioCount; i++) {
        pinMode(gpioWPi[i], OUTPUT);
        digitalWrite(gpioWPi[i], LOW);  // 初始化所有引脚为低电平
    } 
}

void init_gpioPwm(int *values_pwm) {
    while (values_pwm[gpio_softpwmCount] != -1) {
        gpio_softpwmCount++;
    }
    for (int i = 0; i < gpio_softpwmCount ; i++) {
        gpioPwm[i] = values_pwm[i];
    } 
    for(int i = 0; i < gpio_softpwmCount; i++) {
        softPwmCreate(gpioPwm[i], MIN_DUTY, MAX_DUTY);
    } 
}

void pin_all_default() {//全部至低电平,车和坦克共用
	for (int i=0;i<gpioCount;i++) {
        if(gpioWPi[i]==16 || gpioWPi[i]==20 || gpioWPi[i]==22) continue;
		digitalWrite(gpioWPi[i], LOW);
	}
}

void pwm_all_default() {//全部至低电平,车和坦克共用
	for (int i=0;i<gpio_softpwmCount;i++) {
		softPwmWrite(gpioPwm[i], 0);
	}
}

void pwm_value(int pin,int value) {	//软件陪我们控制调速
    for(int i = 0 ; i <= gpio_softpwmCount ; i++) {
        if(pin == gpioPwm[i]) {
            break;
        }
        if(i == gpio_softpwmCount) {
            return ;
        }
    }
    int shot_speed = (int)(shot_speed_value*100);
    if(value==1) {
		
		if(pin == 27){
        softPwmWrite(pin, shot_speed);
        my_zlog_debug("pin:%d,%d",pin,shot_speed);
        } else {
            if(AppExit_pin_pwm == 202)softPwmWrite(pin, 30);
            if(AppExit_pin_pwm != 202 )softPwmWrite(pin, shot_speed);
        }
        

	}else if(value==0) {
		softPwmWrite(pin, 0);
		my_zlog_debug("pin:%d,0",pin);
	}
}


void pin_value(int pin,int value) {	//引脚控制
	for(int i = 0 ; i <= gpioCount ; i++) {
        if(pin == gpioWPi[i]) {
            break;
        }if(i == gpioCount) {
            return ;
        }   
    }
    if(value==1) {
		digitalWrite(pin, HIGH);
		my_zlog_debug("pin:%d,%d",pin,HIGH);
	}else if(value==0) {
		digitalWrite(pin, LOW);
		my_zlog_debug("pin:%d,%d",pin,LOW);
	}
	
}

void pwm_init_speed() {
    int pwm_clock = 24000000 / (50 * 1000);// 定义 PWM 频率为 50Hz
    pinMode(PWM_PIN_SPEED,PWM_OUTPUT);
    pinMode(PWM_PIN_CHANGE,PWM_OUTPUT);
    pwmSetClock(PWM_PIN_SPEED,pwm_clock);//=19200*1000/(hz*2000)
    pwmSetRange(PWM_PIN_SPEED,1000);//占空比范围
    pwmSetClock(PWM_PIN_CHANGE,pwm_clock);//=19200*1000/(hz*2000)
    pwmSetRange(PWM_PIN_CHANGE,1000);//占空比范围
    
}

void Device_exit_end(){//main最后结束需要调用的函数
    if(AppExit_pin_pwm == 202) tank_shot_back_stop_task_end();
}