#ifndef INA226_H
#define INA226_H

#define INA226_ADDRESS              (0x40) // INA226 的 I2C 地址

#define INA226_REG_CONFIG           (0x00)
#define INA226_REG_SHUNTVOLTAGE     (0x01)
#define INA226_REG_BUSVOLTAGE       (0x02)
#define INA226_REG_POWER            (0x03)
#define INA226_REG_CURRENT          (0x04)
#define INA226_REG_CALIBRATION      (0x05)

// 配置 INA226
bool INA226_configure();

// 校准 INA226
bool INA226_calibrate( float rShuntValue, float iMaxExpected);

// 读取总线电压
float INA226_readBusVoltage();

// 读取电流
float INA226_readCurrent();

#endif // INA226_H