#ifndef INFRARED_GUN_H
#define INFRARED_GUN_H

#define IR_PIN_rec 6  // 使用WiringPi,红外接收
#define IR_PIN 25 // 使用WiringPi,红外发射

// NEC协议的基础参数,红外发射
#define START_PULSE_HIGH 9000  // 起始码高电平持续时间（9ms）
#define START_PULSE_LOW 4500   // 起始码低电平持续时间（4.5ms）
#define ONE_PULSE_HIGH 560     // 逻辑1的高电平时间（0.56ms）
#define ONE_PULSE_LOW 1690     // 逻辑1的低电平时间（1.69ms）
#define ZERO_PULSE_HIGH 560    // 逻辑0的高电平时间（0.56ms）
#define ZERO_PULSE_LOW 560     // 逻辑0的低电平时间（0.56ms）
#define STOP_PULSE 500000      // 停止码的低电平时间（500ms）

// NEC协议的基础参数,红外接收
#define START_PULSE_MIN 8500  // 起始码高电平时间最小值（8.5ms）
#define START_PULSE_MAX 9500  // 起始码高电平时间最大值（9.5ms）
#define ONE_PULSE_MIN 1500    // 逻辑1的高电平时间最小值（1.5ms）
#define ONE_PULSE_MAX 1700    // 逻辑1的高电平时间最大值（1.7ms）
#define ZERO_PULSE_MIN 500    // 逻辑0的高电平时间最小值（0.5ms）
#define ZERO_PULSE_MAX 700    // 逻辑0的高电平时间最大值（0.7ms）

int infrared_Init();

void sendNEC(uint32_t data);

void receiveNEC();
#endif