#ifndef device_identity_H__
#define device_identity_H__

#define INITIAL_TABLE_SIZE 10 //定义大小

/*
定义一个枚举类型 CodeEnum，用于表示不同的代码
枚举类型是一种用户自定义的数据类型，它可以让代码更具可读性和可维护性
 */
typedef enum {
    CAR_0101 = 1,
    CAR_0102,
    CAR_0103,
    CAR_0104,
    CAR_0105,
    TANK_0201,
    TANK_0202,
    TANK_0203,
    TANK_0204,
    TANK_0206,
    TANK_0207,
    SHIP_0301,
    PAO_0401,
    PAO_0404,
    PGGPS_0403,
    ROBOT_DOG0501
} CodeEnum_t;

//哈希健
typedef struct HashEntry_t {
    const char *key;
    CodeEnum_t value;
    struct HashEntry_t *next;
} HashEntry_t;

//哈希表内存
typedef struct {
    HashEntry_t **table;
    int size;
} HashTable_t;


/*
设备mqtt的topic初始化函数
*/
int device_mqtt_topic_init();

/*纯设备号*/
char *mqtt_topic_pure_number();

/*app2dev设备号*/
char *mqtt_topic_app2dev_number();

/*dev2app设备号*/
char *mqtt_topic_dev2app_number();

/*ser2dev设备号*/
char *mqtt_topic_ser2dev_number();

#endif