#ifndef PTZ0401_CONTROL_H__
#define PTZ0401_CONTROL_H__

/* ===================== 轴结构体与全局变量 ===================== */
typedef struct {
    // --- 实时状态 ---
    float angle;        // 当前角度
    float target;       // 目标角度
    float speed;        // 当前实时速度

    // --- 静态配置 (每个轴独立) ---
    float min_limit;    // 最小角度限位
    float max_limit;    // 最大角度限位
    float max_speed_cfg;// 最大速度配置 (°/s)
    float accel_cfg;    // 加速度配置 (°/s²)
} ServoAxis;

void device_ptz_pwm_task_threadpoll_init();

void pwm_PTZ_hz();
void PTZ_pwm_init();
void PTZ_pwm_change(unsigned char *buf);
void ptz_pwm_stop();

#endif