#include "common.h"
#include "self_devicecontrol.h"
#include "modules_common.h"
#include "app_device_common.h"
#include "drivers_common.h"


static ThreadPool_t *g_self_devicecontrol_task_t;

static bool g_self_device_control_switch_index=false;//自控开关。是否打开或者关闭

static int self_control_interval=0;

static int self_control_time_count=0;

/*
* @brief 设置g_self_devicecontrol_task_t
*/
void set_device_tasks(devicecontroltask_t *new_tasks) {
    g_self_devicecontrol_task_t = new_tasks;
}

/*
* @brief 自控线程中的任务
*/
void self_device_control_task(){
    static unsigned char s_valt[4];
    device_walk_control(g_device_type,s_valt);
    device_gpio_control(g_device_type,s_valt[1],s_valt[2]);
}

/*
* @brief 自控线程中的计时函数接口,每20ms加一次
* @param[in] self_control_time_count，计时次数
*/
void set_self_control_time_countfuntion(){
    self_control_time_count++;
}

/*
* @brief 自控线程
*/
void self_device_control_task_function(){
    my_zlog_info("自控线程池循环开始");
    while(1){
        if(g_self_device_control_switch_index==true){
            self_device_control_task();
        }else if(g_self_device_control_switch_index==false){
            delay_ms(100);
        }
    }
    my_zlog_info("自控线程池循环终止");
    return ;
}

/*
* @brief 开启自控线程
*/
void self_device_pthrpoll_task_init(){

	g_self_devicecontrol_task_t=thread_pool_init(1,1);
	thread_pool_add_task(g_self_devicecontrol_task_t, self_device_control_task_function, NULL);
	my_zlog_info("自控线程池打开");
}


/*
* @brief 返回自控是否打开的标识接口
*/
bool get_self_control_index(){

    return g_self_device_control_switch_index;
}

/*
* @brief 自控的线程开启标识设置。
* @param[in]  当index为，true为开，false为关
*/
void set_self_control_index(bool index){    
    g_self_device_control_switch_index =index;
}

/*
* @brief 销毁自控的线程
*/
void self_control_thread_close(){
    if(get_self_control_index()==true){
        my_zlog_info("Destroy the thread of the automatic control device");
	    thread_pool_destroy(g_self_devicecontrol_task_t);
    }
    my_zlog_info("The thread of the automatic control device is not opened");
}

/*
* @brief 返回MQTT自控打开或者关闭的函数 
*/
void send_self_contorl_mqtt(){
    // 创建根对象
    cJSON *root = cJSON_CreateObject();
    
    // 创建head对象
    cJSON *head = cJSON_CreateObject();
    cJSON_AddNumberToObject(head, "message_type", 3018);
    cJSON_AddItemToObject(root, "head", head);
    
    // 创建body对象
    cJSON *body = cJSON_CreateObject();
    cJSON_AddStringToObject(body, "cmd", "device_mycontrol");
    cJSON_AddNumberToObject(body, "switch_reply_status", get_self_control_index());
    cJSON_AddItemToObject(root, "body", body);
    
    // 将cJSON对象转换为字符串
    char *json_str = cJSON_PrintUnformatted(root);

    my_zlog_debug("%s",json_str);

    for(int i=0;i<g_mqtt_cam_config_t->mqtt_count;i++){
        mosquitto_publish(g_clients_t[i].mosq, NULL, mqtt_topic_pure_number(), strlen(json_str), json_str, 0, false); 
    } 

    cJSON_Delete(root);  // 释放 cJSON 对象
}


/*
* @brief MQTT接收自控消息的函数 
*/
void receive_self_contorl_mqtt(cJSON *body){

    if (!body) {
        my_zlog_error("JSON error!");
        return;
    }

    cJSON *switch_status = cJSON_GetObjectItem(body, "switch_status");
    static int s_switch_status = 0;
    static bool s_thread_index=0;
    s_switch_status=switch_status->valueint;
    if(s_switch_status == DEVICE_SELF_CONTROL_OPEN){
       if(s_thread_index==0) self_device_pthrpoll_task_init();
       g_self_device_control_switch_index =true;
       s_thread_index=1;
    }else if(s_switch_status == DEVICE_SELF_CONTROL_CLOSE) {
       g_self_device_control_switch_index =false;
    }

     // 2️ id_run 数组
    // cJSON *id_run = cJSON_GetObjectItem(body, "id_run");
    // g_self_devicecontrol_task_t->id_run_count = 0;
    // if (cJSON_IsArray(id_run)) {
    //     int size = cJSON_GetArraySize(id_run);
    //     for (int i = 0; i < size && i < DEVICE_WALK_SIGN_MAX; i++) {
    //         cJSON *item = cJSON_GetArrayItem(id_run, i);
    //         g_self_devicecontrol_task_t->id_run[i] = item->valueint;
    //         g_self_devicecontrol_task_t->id_run_count++;
    //     }
    // }


    send_self_contorl_mqtt();

    return;
}