#ifndef DEVCONTROL_COMMON_H
#define DEVCONTROL_COMMON_H

#include "device_init.h"
#include "gpio_control.h"
#include "car0101_control.h"
#include "car0102_control.h"
#include "car0103_control.h"
#include "car0104_control.h"
#include "ptz0401_control.h"
#include "tank0202_control.h"
#include "tank0203_control.h"
#include "tank0204_control.h"
#include "tank0206_control.h"
#include "ship0301_control.h"
#include "pg0403_serial.h"
#include "tank_common.h"
#include "common.h"

#define DEVICE_CAR0101 101  //莽牛大车
#define DEVICE_CAR0102 102  //莽牛小车
#define DEVICE_CAR0103 103  //推土机
#define DEVICE_CAR0104 104  //挖机
#define DEVICE_TANK0201 201 //废弃坦克
#define DEVICE_TANK0202 202 //
#define DEVICE_TANK0203 203 //M1A2美国坦克
#define DEVICE_TANK0204 204 //美卡隆坦克
#define DEVICE_TANK0206 206 //可以喷水坦克
#define DEVICE_SHIP0301 301 // 32号船
#define DEVICE_PAO_PTZ0401 401 //云台
#define DEVICE_PG_GPS0403 403 //定位设备
#define DEVICE_ROBOT_DOG0501 501 //机械狗


/*
*以下为大类
*/
#define LAND_CAR 1
#define MARINE_TANK 2
#define WATER_TANK 3
#define WATER_SHIP 4
 

typedef struct {
    int device_id;              // 设备ID (101, 102等)
    void (*device_abnormal_stop)(void);    // 车停止
    void (*gpio_pin_pulled)(void);
    void (*gpio_pwm_pulled)(void);
    void (*device_close)(void);// 关闭线程池等
} device_abnormal_close_t;

typedef struct {
    int device_id;              // 设备ID (101, 102等)
    void (*device_didrive_control)(unsigned char *valt);    // PWM初始化函数指针
} device_didrive;



void device_stop(int device_id);

void device_end_close(int device_id);

void device_walk_control(int device_id,unsigned char *valt);

#endif 