#ifndef DEVICE_WIFI_CHANGE_H__
#define DEVICE_WIFI_CHANGE_H__

#include "cjson/cJSON.h"

#define SSID_MAX_LEN 128
#define PASS_MAX_LEN 128
#define CMD_BUFFER_SIZE 256
#define MAX_WIFI_LIST 100

#define default_SSID "jking"
#define default_password "12345678"

#define WIFI_CONF_PATH "/home/orangepi/car/master/device_wifi.conf"
#define WIFI_CONF_DIR "/home/orangepi/car/master"

typedef struct {
    char ssid[SSID_MAX_LEN];
    int signal;
} wifi_info_t;


extern char g_current_ssid[SSID_MAX_LEN];

void scan_wifi_json();//显示以连接WiFi名称和周围已有的WiFi和过滤信号强度低于50的WiFi
int wifi_change_sendmqtt_init();//wifi改变初始化，放在main开头,必须要等mqtt直播就绪才行
void wifi_change_recmqtt(cJSON *body);//接收到修改WiFi指令

void get_current_wifi();//获取已经连接WiFi

//删除对应wifi
int delete_wifi_by_ssid(const char* ssid);

#endif