#ifndef COMMON_H
#define COMMON_H

// ========== 基础必备 ==========
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <stdbool.h>
#include <string.h>
#include <errno.h>


// ========== 硬件相关 ==========
#include <wiringPi.h>      // GPIO控制
#include <softPwm.h>       // PWM控制

// ========== 系统接口 ==========
#include <fcntl.h>         // 文件控制
#include <unistd.h>        // POSIX接口
#include <sys/stat.h>      // 文件状态
#include <dirent.h>        // 目录操作

// ========== 网络通信 ==========
#include <curl/curl.h>     // HTTP客户端

// ========== 高级功能 ==========
#include <termios.h>    // 串口通信
#include <pthread.h>    // 多线程
#include <math.h>       // 数学函数
#include <time.h>       // 时间处理
#include <stddef.h>

#include "mosquitto.h"
#include "cjson/cJSON.h"


#include "delay.h"
#include "mylog.h"



// ========== 香橙派优化宏 ==========
// #define ORANGE_GPIO_SET(pin, val) { \
//     pinMode(pin, OUTPUT); \
//     digitalWrite(pin, val); \
// }

#endif // COMMON_H