#include"common.h"
#include "delay.h"

/*s和ms*/
void delay_ms(int msec) {
    struct timespec ts;
    ts.tv_sec = 0; // 秒
    ts.tv_nsec = msec*1000000; // 1毫秒 = 1000000纳秒
    nanosleep(&ts,NULL);
}

void delay_s(int sec) {
    struct timespec ts;
    ts.tv_sec = sec; // 秒
    ts.tv_nsec = 0; // 1毫秒 = 1000000纳秒
    nanosleep(&ts,NULL);
}

/*us*/
void delay_us(int usec) {
    struct timespec ts;
    ts.tv_nsec = usec*1000; // 1毫秒 = 1000000纳秒
    nanosleep(&ts,NULL);
}

// 函数功能：获取当前精确到毫秒的时间戳
// 返回值：当前时间的毫秒数
long long get_current_time_millis() {
    struct timeval tv;
    // 获取当前时间，存储在tv结构体中，第二个参数一般传NULL
    if (gettimeofday(&tv, NULL)!= 0) {
        perror("gettimeofday error");
        return -1;
    }
    // 秒数部分转换为毫秒（乘以1000），微秒数部分转换为毫秒（除以1000），然后相加
    return (long long)tv.tv_sec * 1000 + tv.tv_usec / 1000;
}