#ifndef MQTT_VERIFY_H__
#define MQTT_VERIFY_H__

#include "cjson/cJSON.h"
#include <pthread.h> 
#include <stdbool.h> 

/*TRUE为打开验证，FALSE为关闭验证*/
extern bool VERIFIED_MODE;

#define AES_BLOCK_SIZE 16

extern pthread_mutex_t g_verify_mutex;
extern int g_verify_count;//验证计时
extern int g_verify_index;//判断是否验证成功

int receive_jwt(cJSON *body);//jwt验证

int message2006_verify(cJSON *body);

/*接收到是否打开验证的函数*/
int message2013_recverigy_open(cJSON *body);

/*发送是否打开验证的mqtt给后端验证初始化*/
int verify_open_index_init();

void mqtt_verify_data_clear(cJSON *body);
#endif