#include "common.h"
#include "modules_common.h"
#include "tank0202_control.h"
#include "gpio_common.h"

int g_modecount_tank0202=0;

void tank0202_middle() {
    pwmWrite(PWM_PIN_SPEED,75);
    pwmWrite(PWM_PIN_CHANGE,75);
}

void mode_lift_flont(unsigned char gval) {
		int b=0;
   if (gval < 50) {
		pwmWrite(PWM_PIN_SPEED, 75);
	}
	else if (gval <= 60) {
		pwmWrite(PWM_PIN_SPEED, 79+b);
	}else if (gval <= 70) {
		pwmWrite(PWM_PIN_SPEED, 80+b);
	}else if(gval >70){
		int flont_speed = 80+(gval-70)/10+b;
		if(flont_speed>95) flont_speed = 95;
		pwmWrite(PWM_PIN_SPEED, flont_speed);
	}
}

void mode_lift_back(unsigned char gval) {
	int b=0;
	if (gval < 50) {
		pwmWrite(PWM_PIN_SPEED, 75);
	} else if (gval <= 60) {
		pwmWrite(PWM_PIN_SPEED, 71-b);
	}else if (gval <= 70) {
		pwmWrite(PWM_PIN_SPEED, 70-b);
	} else if(gval >70){
		int back_speed = 70 - (gval-70)/10-b;
		if(back_speed<55) back_speed =55;
		pwmWrite(PWM_PIN_SPEED, back_speed);
	}     
}

void mode_right_flont(unsigned char gval) {
	int b=0;
   if (gval < 50) {
		pwmWrite(PWM_PIN_CHANGE, 75);
	}else if (gval <= 60) {
		pwmWrite(PWM_PIN_CHANGE, 79+b);
	}else if (gval <= 70) {
		pwmWrite(PWM_PIN_CHANGE, 80+b);
	}else if(gval >70){
		int flont_speed = 80+(gval-70)/10+b;
		if(flont_speed>95) flont_speed = 95;
		pwmWrite(PWM_PIN_CHANGE, flont_speed);
	}
}

void mode_right_back(unsigned char gval) {
		int b=0;
	if (gval < 50) {
		pwmWrite(PWM_PIN_CHANGE, 75);
	}else if (gval <= 60) {
		pwmWrite(PWM_PIN_CHANGE, 71-b);
	} else if (gval <= 70) {
		pwmWrite(PWM_PIN_CHANGE, 70-b);
	} else if(gval >70){
		int back_speed = 70 - (gval-70)/10-b;
		if(back_speed<55) back_speed =55;
		pwmWrite(PWM_PIN_CHANGE, back_speed);
	}
}


int tank0202_change_grading(int mode){
	int mode_val=0;
		switch(mode){
			case 2:
				mode_val=10;
				break;
			case 3:
				mode_val=20;
				break;
			case 4:
				mode_val=30;
				break;
			case 5:
				mode_val=50;
				break;
			default:
				break;
		}
		return mode_val;
}

void  tank0202_change(unsigned char *buf) {
	unsigned char type = buf[0];
    unsigned char mode = buf[1];
    unsigned char val = buf[2];

	static int tank0202_steering_t=0;
	static int tank0202_front_t =0;

	static int tank0202_front_val=0;
	static int tank0202_steering_val=0;
	
	int tank0202_count=40;

	if(type != 1) tank0202_count=tank0202_change_grading(type);

	if((mode == 1 ||mode == 2)&&val == 0) tank0202_front_t =0;
	if((mode == 3 ||mode == 4)&&val == 0) tank0202_steering_t=0;

	if(mode == 1&&val != 0) {
		tank0202_front_val=val;
		tank0202_front_t =1;
	}else if(mode == 2&&val != 0) {
		tank0202_front_t =2;
		tank0202_front_val=val;
	}

	if(mode == 3&&val != 0) {
		tank0202_steering_t =1;
		tank0202_steering_val = val;
	}else if(mode == 4&&val != 0) {
		tank0202_steering_t =2;
		tank0202_steering_val = val;
	}

	if(tank0202_front_t ==0&&tank0202_steering_t==0){
		mode_lift_flont(0);
        mode_right_flont(0);
	}else if(tank0202_front_t ==1&&tank0202_steering_t==0){
			mode_right_flont(tank0202_front_val+10);
			mode_lift_flont(0);
	}else if(tank0202_front_t ==2&&tank0202_steering_t==0){
			mode_right_back(tank0202_front_val+10);
			mode_lift_back(0);
	}else if(tank0202_front_t ==0&&tank0202_steering_t==1){
			mode_lift_back(tank0202_steering_val + tank0202_count+20);
			mode_right_back(0);
	}else if(tank0202_front_t ==0&&tank0202_steering_t==2){
			mode_lift_flont(tank0202_steering_val + tank0202_count+20);
			mode_right_back(0);
	}
	else if(tank0202_front_t ==1&&tank0202_steering_t==1){
		mode_lift_back(tank0202_steering_val + 10);
        mode_right_flont(tank0202_steering_val + 20);
	}else if(tank0202_front_t ==1&&tank0202_steering_t==2){
		mode_lift_flont(tank0202_steering_val +10);
        mode_right_flont(tank0202_steering_val + 20);
	}else if(tank0202_front_t ==2&&tank0202_steering_t==1){
		mode_lift_back(tank0202_steering_val + 10);
        mode_right_back(tank0202_steering_val + 20);
	}else if(tank0202_front_t ==2&&tank0202_steering_t==2){
		mode_lift_flont(tank0202_steering_val + 10);
        mode_right_back(tank0202_steering_val + 20);
	}
	
    
}
