#include "main.h"
#include "wifi_autoconfig.h"

int main()
{
   if (mylog_init() != 0)
   {
      my_zlog_error("日志初始化失败，错误代码：%d", mylog_init());
      return -1;
   }

   if (wiringPiSetup() == -1)
   {
      my_zlog_fatal("WiringPi setup failed!");
      return -2;
   }

   if (device_id_file_init() != 0)
   {
      my_zlog_error("设备id读取失败");
      return -3;
   }
   if (device_mqtt_topic_init() != 0)
   {
      my_zlog_error("设备id判断失败");
      return -4;
   }

   // 初始化音频，确保配网时的提示音能听到
   if (audio_config_init() != 0)
   {
      my_zlog_warn("音频配置初始化失败");
   }

   if (audio_init() == 0)
   {
      my_zlog_info("音频命令执行初始化成功");
   }

   // 3. 在这里检查网络。如果没网 -> 进入扫码配网 (死循环直到成功)
   check_and_autoconfig_wifi();

   if (request_date() != 0)
   {
      my_zlog_error("请求数据失败");
      return -5;
   }

   if (http_mqtt_video_init() != 0)
   {
      my_zlog_error("请求mqtt服务器和video数据失败");
      return -6;
   }

   // 检查并更新 Go 程序
   if (go_deploy_check_and_update() != 0)
   {
      my_zlog_warn("Go 程序检查/部署失败");
   }

   // 启动 Unix Socket 服务，用于 C 和 Go 程序通信
   if (ipc_start_unix_server(NULL) != 0)
   {
      my_zlog_warn("IPC Unix Socket Server 启动失败");
      return -8;
   }

   // 音频初始化已移至开头

   if (hardware_iic_init() != 0)
   {
      my_zlog_error("硬件iic初始化失败");
      return -7;
   }

   if (device_shot_cooling_init() != 0)
   {
      my_zlog_warn("该设备没有冷却");
   }

   

   int thread_rc = thread_start_init(thread_exit_time, thread_mqtt_beat,
                                     thread_open_browser, thread_mqtt_reconnect, thread_time_calculation, thread_play_mp3);
   if (thread_rc != 0)
   {
      my_zlog_warn("多线程初始化失败");
      return -7;
   }

   // 初始化全部完成，播放“连接成功”提示音，作为系统就绪的标志
   play_audio_file("connectionSuccessful.mp3");

   thread_end_close();
   device_end_close(g_device_type);
   self_control_thread_close(); // 销毁自控的线程
   my_log_close();              // 关闭日志
   hardware_iic_close();
   my_zlog_info("程序关闭成功");
   return 0;
}