#ifndef COMMON_H
#define COMMON_H

// ========== 基础必备 ==========
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <stdbool.h>
#include <string.h>
#include <errno.h>
#include <stddef.h>
#include <errno.h>

// ========== 硬件相关 ==========
#include <wiringPi.h>      // GPIO控制
#include <softPwm.h>       // PWM控制

// ========== 系统接口 ==========
#include <fcntl.h>         // 文件控制
#include <unistd.h>        // POSIX接口
#include <sys/stat.h>      // 文件状态
#include <dirent.h>        // 目录操作
#include <sys/types.h>
#include <sys/select.h>
#include <pty.h> // for openpty

// ========== 网络通信 ==========
#include <curl/curl.h>     // HTTP客户端
#include <sys/socket.h>
#include <netinet/in.h> 
#include <arpa/inet.h>
#include <ifaddrs.h>

// ========== 高级功能 ==========
#include <termios.h>    // 串口通信
#include <pthread.h>    // 多线程
#include <math.h>       // 数学函数
#include <time.h>       // 时间处理
#include <uuid/uuid.h>
#include <signal.h>

// ========== 第三方库 ==========
#include "mosquitto.h"
#include "cjson/cJSON.h"

// ========== 自己封装的库 ==========
#include "delay.h"
#include "mylog.h"

// 定义一个结构体表示串口，整洁
typedef struct {
    int fd;
    char port_name[64];
    int is_open;
} SerialPort;

#endif // COMMON_H