#include "common.h"
#include "device_exit.h"
#include "gpio_common.h"
#include "gpio_pwm_carship.h"
#include "gpio_pwm_ptz.h"
#include "gpio_pwm_tank0202.h"
#include "gpio_pwm_car0102.h"
#include "gpio_pwm_car0103.h"
#include "gpio_pwm_car0104.h"
#include "mqtt.h"



void car_exit_0101() {
    middle_pwm();
    pin_all_default();
}

void car_exit_0102() {
    car0102_speed_stop();
    pin_all_default();
}

void car_exit_0103() {
    car0103_middle();
    pin_all_default();
}

void car_exit_0104() {
    car0104_middle();
    pin_all_default();
}

void tank_exit_0201() {
    pin_all_default();
    digitalWrite(2, LOW);
    digitalWrite(21, LOW);
}

void tank_exit_0202() {
    pin_all_default();
    pwm_all_default();
    tank0202_middle();
}

void ship_exit_0301() {
    ship_stop_pwm();
    pin_all_default();
}

void ptz_exit_0401() {
    pwm_all_default();
    pin_all_default();
}

void device_warn_exit(){
    if(AppExit_pin_pwm==101) car_exit_0101();//车0101异常问题处理
    if(AppExit_pin_pwm==102) car_exit_0102();//车0102异常问题处理
    if(AppExit_pin_pwm==103) car_exit_0103();//车0103异常问题处理
    if(AppExit_pin_pwm==104) car_exit_0104();//车0103异常问题处理
    if(AppExit_pin_pwm==201) tank_exit_0201();//坦克0201异常问题处理  
    if(AppExit_pin_pwm==202) tank_exit_0202(); //坦克0202异常问题处理 
    if(AppExit_pin_pwm==301) ship_exit_0301();//船异0301常问题处理
    if(AppExit_pin_pwm==401) ptz_exit_0401();//炮异0401常问题处理
}