#include "common.h"
#include "thread_main.h"
#include "mqtt.h"
#include "judg.h"
#include "delay.h"
#include "car.h"
#include "tank.h"
#include "ship.h"
#include "pao.h"
#include "fileopen.h"
#include "device_change.h"

char TOPIC_middle[23];
char TOPIC2_middle[23];
char TOPIC3_middle[15];
char TOPIC4_middle[23];

bool device_name_exists=0;

// char TOPIC_BACK_middle[23];
// char TOPIC2_BACK_middle[23];
// char TOPIC3_BACK_middle[15];

void topic_middle_value() {//指针中转函数，在使用指针前调用
    TOPIC=TOPIC_middle;
    TOPIC2=TOPIC2_middle;
    TOPIC3=TOPIC3_middle;
    TOPIC4=TOPIC4_middle;
}

// void topic_back_middle_value() {//指针中转函数，在使用指针前调用
//     TOPIC_BACK=TOPIC_BACK_middle;
//     TOPIC2_BACK=TOPIC2_BACK_middle;
//     TOPIC3_BACK=TOPIC3_BACK_middle;
// }

// 哈希函数：简单的字符串哈希
unsigned int hash(const char *str, int tableSize) {
    unsigned int hash = 0;
    while (*str) {
        hash = (hash << 5) + *str++;
    }
    return hash % tableSize;
}

// 创建哈希表
HashTable* createHashTable(int size) {
    HashTable *hashTable = (HashTable *)malloc(sizeof(HashTable));
    hashTable->size = size;
    hashTable->table = (HashEntry **)malloc(sizeof(HashEntry *) * size);
    for (int i = 0; i < size; i++) {
        hashTable->table[i] = NULL;
    }
    return hashTable;
}

// 插入元素到哈希表
void insert(HashTable *hashTable, const char *key, CodeEnum value) {
    unsigned int index = hash(key, hashTable->size);
    HashEntry *newEntry = (HashEntry *)malloc(sizeof(HashEntry));
    newEntry->key = key;
    newEntry->value = value;
    newEntry->next = hashTable->table[index];
    hashTable->table[index] = newEntry;
}

// 查找元素
CodeEnum find(HashTable *hashTable, const char *key) {
    unsigned int index = hash(key, hashTable->size);
    HashEntry *entry = hashTable->table[index];
    while (entry) {
        if (strcmp(entry->key, key) == 0) {
            return entry->value;
        }
        entry = entry->next;
    }
    return -1;  // 未找到
}

int hash_insert_init(HashTable *hashTable) {

    // 插入已有的代码
    insert(hashTable, "0101", CAR_0101);
    insert(hashTable, "0102", CAR_0102);
    insert(hashTable, "0103", CAR_0103);
    insert(hashTable, "0104", CAR_0104);
    insert(hashTable, "0201", TANK_0201);
    insert(hashTable, "0202", TANK_0202);  
    insert(hashTable, "0301", SHIP_0301);
    insert(hashTable, "0401", PAO_0401);
}

int Device_judg(CodeEnum code,char *sub_str) {
    if (code == CAR_0101) {
        car_Init_0101();
        my_zlog_info("使用型号%s",sub_str);
    }else if(code == CAR_0102) {
        car_Init_0102();
        my_zlog_info("使用型号%s",sub_str);
    }else if(code == CAR_0103) {
        car_Init_0103();
        my_zlog_info("使用型号%s",sub_str);
    }else if(code == CAR_0104) {
        car_Init_0104();
        my_zlog_info("使用型号%s",sub_str);
    }else if(code == TANK_0201) {
        tank_Init_0201();
        my_zlog_info("使用型号%s",sub_str);
    }else if(code == TANK_0202) {
        tank_Init_0202();
        my_zlog_info("使用型号%s",sub_str);
    }else if(code == SHIP_0301) {
        ship_Init_0301();
        my_zlog_info("使用型号%s",sub_str);
    }else if(code ==PAO_0401) {
        ptr_Init_0401();
        my_zlog_info("使用型号%s",sub_str);   
    }else {
        my_zlog_error("没有找到设备号,尝试启用备用mqtt,topic进行改名");
        device_name_exists=1;
        //exit(0);
    }
    return 0;
}

int Device_File_Init() {//设备文件读取函数
    char *readmidbuf=device_inspect(); //读取代码
    if(strlen(readmidbuf) > 14 && readmidbuf[14]=='\n') readmidbuf[14]='\0';//将\n去除

    const char *readbuf = readmidbuf;

    //将第3个和第4个字符提取出来
    char *sub_str=malloc(5);
    sub_str[0]=readbuf[2];
    sub_str[1]=readbuf[3];
    sub_str[2]=readbuf[4];
    sub_str[3]=readbuf[5];
    sub_str[4]='\0';
    my_zlog_info("开始初始化了");

    HashTable *hashTable = createHashTable(INITIAL_TABLE_SIZE);//创造hash表
    hash_insert_init(hashTable);//hash表初始化
    CodeEnum code = find(hashTable, sub_str);
    
    if(Device_judg(code,sub_str) == 0) my_zlog_info("判断成功了");

    free(sub_str);
          
    Delay_Ms(20,0);
    if(device_name_exists == 0) {
        sprintf(TOPIC2_middle,"dev2app/%s",readbuf);
        sprintf(TOPIC_middle,"app2dev/%s",readbuf);
        sprintf(TOPIC3_middle,"%s",readbuf);
        sprintf(TOPIC4_middle,"ser2dev/%s",readbuf);
    } else {
        sprintf(TOPIC2_middle,"dev2app/%s","00000000000000");
        sprintf(TOPIC_middle,"app2dev/%s","00000000000000");
        sprintf(TOPIC3_middle,"%s","00000000000000");
        sprintf(TOPIC4_middle,"ser2dev/%s","00000000000000");
    }


    topic_middle_value();//指针传值声明

    my_zlog_info("1:%s,2:%s,3:%s",TOPIC,TOPIC2,TOPIC3);
    return 0;
}
