#include "fileopen.h"
#include "common.h"
#include "delay.h"
#include "device_change.h"

char buffer_device[30]; // 用于存储文件内容
char buffer_version[30];// 用于存储版本号内容

char *device_inspect() {//读出文件函数
    FILE *file;
    char *read_device_back_fail_middle=read_device_back_fail();    
    while (1) {
        file = fopen(FILENAME, "r"); // 以只读模式打开文件

        if (file == NULL) {
            if(read_device_back_fail_middle!=NULL) {//回退文件
            return read_device_back_fail_middle;
           }
            my_zlog_debug("文件 %s 打开失败，等待中...", FILENAME);
        } 
        else {
            // 尝试读取文件内容
            if (fgets(buffer_device, sizeof(buffer_device), file) != NULL) {
                // 如果文件内容不为空
                fclose(file);
                my_zlog_debug("读取到文件内容: %s", buffer_device);
                return  buffer_device;
            } else {
                if(read_device_back_fail_middle!=NULL) {
                    fclose(file);
                    return read_device_back_fail();
                }
                my_zlog_debug("文件为空，等待中...");
            }
            fclose(file);
        }
    Delay_Ms(1,0); // 等待1秒后再次检查
    }
}

char *program_version() {//打开版本文件
    FILE *file;
    file = fopen(FILE_VERSION, "r"); // 以只读模式打开文件
    if (file == NULL) {
            my_zlog_debug("版本文件无");
        }  else {
            // 尝试读取文件内容
            if (fgets(buffer_version, sizeof(buffer_version), file) != NULL) {
                // 如果文件内容不为空
                fclose(file);
                my_zlog_debug("读取到文件内容: %s", buffer_version);
                return  buffer_version;
            } else {
                my_zlog_debug("文件为空，等待中...");
            }
            fclose(file);
        }
}