#include <sys/socket.h>
#include <netinet/in.h> 
#include <ifaddrs.h>
#include "common.h"
#include "ip.h"

struct ifaddrs *ifap, *ifa;
struct sockaddr_in *sa;

char ip_address[INET_ADDRSTRLEN];

int ipaddr() {//获取ip
    if (getifaddrs(&ifap) == -1) {
        //perror("getifaddrs() error");
        my_zlog_error("getifaddrs() error");
        return -1;
    }

    for (ifa = ifap; ifa != NULL; ifa = ifa->ifa_next) {
        if (ifa->ifa_addr != NULL && ifa->ifa_addr->sa_family == AF_INET) {
            sa = (struct sockaddr_in *) ifa->ifa_addr;
            inet_ntop(AF_INET, &sa->sin_addr, ip_address, sizeof(ip_address));
        }
    }
    
    //printf("ip:%s\n",ip_address);
   // my_zlog_debug("ip:%s",ip_address);

    freeifaddrs(ifap);
    
    return 0;
}


