#include "common.h"
#include "warm.h"
#include "mqtt.h"
#include "gpio_pwm_carship.h"
#include "request.h"

//最高警报，最低电压报警
int alarm_highest(int index) {
    if(index == 1) {
        pin_value(20,1);//紫灯
        if(enable_buzzer_value) {
            pin_value(22,1);//蜂鸣器
        }
    }else if(index == 0) {
        pin_value(20,0);//紫灯
        pin_value(22,0);//蜂鸣器
    }

    return index ;
}

//比较小警报
int alarm_low(int index) {
    if(index == 1) {
        pin_value(16,1);//黄灯
    } else if(index == 0) {
        pin_value(16,0);//黄灯
    } 

    return index ;
}

int alarm_control(float voltage) {//关闭警报
    if(gPwmCount >= 5) {
        if( voltage >= warn_voltage_value ) {
            alarm_highest(0);
            alarm_low(0);
        }else if(voltage >= err_voltage_value&&voltage <= warn_voltage_value) {
            alarm_low(1);
            alarm_highest(0);
            my_zlog_warn("电压警告");
        }else if(voltage < err_voltage_value) {
            alarm_highest(1);
            alarm_low(1);
            my_zlog_warn("换电警告");
        }   
    }
    return 0; 
}
