#include "main.h"

void audio_Init() {

    int adino_jude = system("pactl load-module module-alsa-source device=hw:2,0");
    Delay_Ms(3,0);
    int adino_play_jude =system("pactl load-module module-alsa-sink device=hw:2,0");

    
    if (adino_jude  == 0 && adino_play_jude==0 ) {
        my_zlog_debug("命令执行成功！");
    } else {
        if(adino_jude  != 0) my_zlog_warn("麦命令执行失败，返回状态码: %d", adino_jude );
        if(adino_play_jude!=0) my_zlog_warn("喇叭命令执行失败，返回状态码: %d", adino_play_jude );
    }
}

int main_start_error_return() {
    if(logconf_create() != 0) {
        return 1;
    }
    if(logprject_Init() != 0) {
        my_zlog_fatal( "日志初始化失败");
        return 2;
    }
    if (wiringPiSetup() == -1) {
        my_zlog_fatal("WiringPi setup failed!");
        return 3;
    }
    if (!SOFTiic_init()) {
        my_zlog_fatal("INA226 初始化失败或者ads1115初始化失败！");
        return 4;
    }
    if(Device_File_Init()!=0) {
        my_zlog_fatal("This is a fatal message");
        return 5;
    }
    if(request_date() != 0) {
        my_zlog_fatal("This is a fatal message");
        return 6;
    }

    audio_Init();//音频初始化

    my_zlog_info("程序初始化成功");
    system("pkill  chromium");
    
    // 配置 INA226
    if(!INA226_configure()) {
        my_zlog_warn("INA226初始化失败");
    }
    // 校准 INA226
    float rShuntValue = 0.01; // 分流电阻值（单位：欧姆）
    float iMaxExpected = 5; // 最大预期电流（单位：安培）
    if(!INA226_calibrate(rShuntValue, iMaxExpected)){
        my_zlog_warn("INA226校准失败");
    }

    gStart=time(NULL);//开始时间戳

    if(ipaddr() != 0) {//获取ip
        my_zlog_fatal("Ip获取失败");
        return -1;
    }
    if(thread_start(AppExit,Mqttbeat,opensh,Mqtt_onnect,delay_count,play_mp3_thread) !=0 ) {//开启线程)
         my_zlog_fatal("开启线程失败");
         return -1 ;
    }
    return 0;
}

int main(int argc, char *argv[]) {

    if(main_start_error_return()!=0){
        my_zlog_error("程序错误代码：%d\n",main_start_error_return());
        return -1;
    }

    thread_end(); //关闭线程
    my_zlog_info("程序关闭成功");
    my_log_close();//关闭日志

    Device_exit_end();//结束相应的设备的程序执行

    return EXIT_SUCCESS;
}