#ifndef SELF_DEVICECONTROL_H
#define SELF_DEVICECONTROL_H

/**
 * @file self_devicecontrol.h
 * @brief 设备自己控制模块头文件
 */

#define DEVICE_WALK_SIGN_MAX 100

#define DEVICE_SELF_CONTROL_OPEN 1

#define DEVICE_SELF_CONTROL_CLOSE 0

//结构体，用来存放这些
typedef struct {
    int id_run[DEVICE_WALK_SIGN_MAX];
    int id_run_count;
    int run_cool[DEVICE_WALK_SIGN_MAX];
    int timed_run[DEVICE_WALK_SIGN_MAX];
} devicecontroltask_t;

// 单个设备动作数据结构
typedef struct{
    int mode[DEVICE_WALK_SIGN_MAX];
    int val[DEVICE_WALK_SIGN_MAX];
    int action_count;
}device_automatic_date_t;


void set_self_control_time_countfuntion();//计时

void self_control_thread_close();//销毁自控的线程

void receive_self_contorl_mqtt(cJSON *body);

void receive_self_contorl_date_mqtt(cJSON *body);//数据保存

bool get_self_control_index();

void set_self_control_index(bool index);

int get_device_self_control_configuration_initialization();//开机需要进行配置自控相关的初始化
#endif