#ifndef TANK_COMMON_H
#define TANK_COMMON_H

#include "common.h"

typedef struct {
    int device_id;              // 设备ID (101, 102等)
    int back_time;
    int back_interval_back;
    int shot_back_speed;
    int(*shot_back)(unsigned char pin,unsigned char val);
} tank_common_back;

typedef enum {
    shot,
    shot_stop
}shot_state;

/*坦克射击接口，只有在特定设备号下使用*/
void tank_shot_stop_control(int device_id,unsigned char pin,unsigned char val);

/*设置后退的时间重置s*/
void set_tank_shot_index_cool(bool index);

/*获取后退状态*/
bool get_backstatus();

/*用来判断有射击冷却的检测的状态获取*/
bool getshot_detection_index();

/*用来设置有射击冷却的检测的状态获取*/
bool setshot_detection_index(bool flag);

/*获取是否在射击，射击状态*/
bool get_backshotstatus();

/*获取是否在射击，射击状态*/
bool set_backshotstatus(bool flag);

/*检测的冷却时间，flag=0时初始化冷却时间，2是计时，3是返回计时值*/
int tankshot_detection_backcount(int *cool_time,int flag);

/*关闭线程*/
void tank_thread_close();

#endif